/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public interface AzResourceBase {
    public boolean exists();

    @Nonnull
    public String getName();

    @Nonnull
    public String getId();

    @Nonnull
    public String getSubscriptionId();

    @Nonnull
    public String getResourceGroupName();

    @Nonnull
    public String getStatus();

    @Nonnull
    public Subscription getSubscription();

    @Nonnull
    public String getPortalUrl();

    default public FormalStatus getFormalStatus() {
        return StringUtils.isBlank((CharSequence)this.getStatus()) ? FormalStatus.UNKNOWN : FormalStatus.dummyFormalize(this.getStatus());
    }

    public static enum FormalStatus {
        RUNNING,
        STOPPED,
        FAILED,
        DELETED,
        UNKNOWN,
        WRITING,
        READING,
        CREATING,
        DELETING;

        private static final HashSet<String> runningStatus;
        private static final HashSet<String> stoppedStatus;
        private static final HashSet<String> failedStatus;
        private static final HashSet<String> writingStatus;
        private static final HashSet<String> readingStatus;
        private static final HashSet<String> deletingStatus;
        private static final HashSet<String> deletedStatus;

        public static FormalStatus dummyFormalize(String status) {
            if (runningStatus.contains(status = status.toLowerCase())) {
                return RUNNING;
            }
            if (stoppedStatus.contains(status)) {
                return STOPPED;
            }
            if (failedStatus.contains(status)) {
                return FAILED;
            }
            if (status.equals("creating")) {
                return CREATING;
            }
            if (writingStatus.contains(status)) {
                return WRITING;
            }
            if (readingStatus.contains(status)) {
                return READING;
            }
            if (deletingStatus.contains(status)) {
                return DELETING;
            }
            if (deletedStatus.contains(status)) {
                return DELETED;
            }
            return UNKNOWN;
        }

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isStopped() {
            return this == STOPPED;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isDeleted() {
            return this == DELETED;
        }

        public boolean isCreating() {
            return this == CREATING;
        }

        public boolean isDeleting() {
            return this == DELETING;
        }

        public boolean isWriting() {
            return this == WRITING || this.isCreating();
        }

        public boolean isReading() {
            return this == READING;
        }

        public boolean isWaiting() {
            return this.isWriting() || this == READING;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isWritable() {
            return this.isConnected() && !this.isFailed() && !this.isWriting();
        }

        public boolean isConnected() {
            return !this.isDeleted() && !this.isUnknown() && !this.isCreating() && !this.isDeleting();
        }

        static {
            runningStatus = Sets.newHashSet((Object[])new String[]{"running", "success", "succeeded", "ready", "ok"});
            stoppedStatus = Sets.newHashSet((Object[])new String[]{"stopped", "deallocated"});
            failedStatus = Sets.newHashSet((Object[])new String[]{"failed", "error"});
            writingStatus = Sets.newHashSet((Object[])new String[]{"writing", "pending", "processing", "updating", "starting", "stopping", "restarting", "scaling"});
            readingStatus = Sets.newHashSet((Object[])new String[]{"reading", "loading", "refreshing"});
            deletingStatus = Sets.newHashSet((Object[])new String[]{"deleting"});
            deletedStatus = Sets.newHashSet((Object[])new String[]{"deleted", "removed", "disconnected"});
        }
    }
}

