/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log {
    private static final Logger log = LoggerFactory.getLogger(Log.class);

    public static void error(String message) {
        log.error(message);
    }

    public static void error(Exception error) {
        log.error(Log.getErrorDetail(error));
    }

    public static void info(String message) {
        log.info(message);
    }

    public static void info(Exception error) {
        log.info(Log.getErrorDetail(error));
    }

    public static void debug(String message) {
        log.debug(message);
    }

    public static void debug(Exception error) {
        log.debug(Log.getErrorDetail(error));
    }

    public static void warn(String message) {
        log.warn(message);
    }

    public static void warn(Exception error) {
        log.warn(Log.getErrorDetail(error));
    }

    public static boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public static void prompt(String message) {
        if (log.isInfoEnabled()) {
            log.info(message);
        } else {
            System.out.println(message);
        }
    }

    private static String getErrorDetail(Exception error) {
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        String exceptionDetails = sw.toString();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exceptionDetails;
    }
}

