/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils.aspect;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.google.common.collect.ImmutableMap;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.codehaus.groovy.runtime.MethodClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExpressionUtils.class);
    private static final ImmutableMap<String, Boolean> valueMap = ImmutableMap.of((Object)"true", (Object)true, (Object)"false", (Object)false);
    private static final SimpleTemplateEngine engine = new SimpleTemplateEngine();
    private static final String INVALID_TEMPLATE = "error occurs when evaluate template(%s) with bindings(%s)";

    public static boolean evaluate(@Nonnull String expression, @Nonnull MethodInvocation invocation, boolean defaultVal) {
        String result = ExpressionUtils.interpret(expression, invocation);
        return Boolean.TRUE.equals(valueMap.getOrDefault(Optional.ofNullable(result).map(String::toLowerCase).orElse(null), (Object)defaultVal));
    }

    public static String interpret(@Nonnull String expression, @Nonnull MethodInvocation invocation) {
        return ExpressionUtils.render(String.format("${%s}", expression), invocation);
    }

    public static String render(@Nullable String template, @Nonnull MethodInvocation invocation) {
        if (StringUtils.isBlank((CharSequence)template) || !template.contains("$")) {
            return template;
        }
        Map<String, Object> bindings = ExpressionUtils.initBindings(invocation);
        String fixed = template.replaceAll("(\\W)this(\\.)", "$1_this_$2");
        try {
            Template tpl = engine.createTemplate(fixed);
            return tpl.make(bindings).toString();
        }
        catch (Throwable e) {
            log.warn(String.format(INVALID_TEMPLATE, template, bindings), e);
            return template;
        }
    }

    @Nonnull
    private static Map<String, Object> initBindings(@Nonnull MethodInvocation invocation) {
        List<Triple<String, Parameter, Object>> args = invocation.getArgs();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        for (Triple<String, Parameter, Object> arg : args) {
            bindings.put((String)arg.getLeft(), arg.getRight());
        }
        bindings.put("_this_", invocation.getInstance());
        ExpressionUtils.bindPredefinedFunctions(bindings);
        return bindings;
    }

    private static void bindPredefinedFunctions(@Nonnull Map<String, Object> bindings) {
        bindings.put("nameFromResourceId", new MethodClosure(ResourceUtils.class, "nameFromResourceId"));
    }
}

