/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Emitter;
import rx.Observable;

public abstract class AzureTaskManager {
    private static final Logger log = LoggerFactory.getLogger(AzureTaskManager.class);
    private static AzureTaskManager instance;

    public static synchronized void register(AzureTaskManager manager) {
        if (instance == null) {
            instance = manager;
        }
    }

    public static AzureTaskManager getInstance() {
        return instance;
    }

    public final void read(Runnable task) {
        this.read(new AzureTask<Void>(task));
    }

    public final void read(String title, Runnable task) {
        this.read(new AzureTask<Void>(title, task));
    }

    public final void read(AzureString title, Runnable task) {
        this.read(new AzureTask<Void>(title, task));
    }

    public final void read(AzureTask<Void> task) {
        this.runInObservable(this::doRead, task).subscribe();
    }

    public final void write(Runnable task) {
        this.write(new AzureTask<Void>(task));
    }

    public final void write(String title, Runnable task) {
        this.write(new AzureTask<Void>(title, task));
    }

    public final void write(AzureString title, Runnable task) {
        this.write(new AzureTask<Void>(title, task));
    }

    public final void write(AzureTask<Void> task) {
        this.runInObservable(this::doWrite, task).subscribe();
    }

    public final void runImmediately(Runnable task) {
        this.runImmediatelyAsObservable(task).subscribe();
    }

    public final void runLater(Runnable task) {
        this.runLater(new AzureTask<Void>(task));
    }

    public final void runLater(String title, Runnable task) {
        this.runLater(new AzureTask<Void>(title, task));
    }

    public final void runLater(AzureString title, Runnable task) {
        this.runLater(new AzureTask<Void>(title, task));
    }

    public final void runLater(Runnable task, AzureTask.Modality modality) {
        this.runLater(new AzureTask<Void>(task, modality));
    }

    public final void runLater(String title, Runnable task, AzureTask.Modality modality) {
        this.runLater(new AzureTask<Void>(title, task, modality));
    }

    public final void runLater(AzureString title, Runnable task, AzureTask.Modality modality) {
        this.runLater(new AzureTask<Void>(title, task, modality));
    }

    public final void runLater(AzureTask<Void> task) {
        this.runInObservable(this::doRunLater, task).subscribe();
    }

    public final void runOnPooledThread(Runnable task) {
        this.runOnPooledThreadAsObservable(task).subscribe();
    }

    public final void runAndWait(Runnable task) {
        this.runAndWait(new AzureTask<Void>(task));
    }

    public final void runAndWait(String title, Runnable task) {
        this.runAndWait(new AzureTask<Void>(title, task));
    }

    public final void runAndWait(AzureString title, Runnable task) {
        this.runAndWait(new AzureTask<Void>(title, task));
    }

    public final void runAndWait(Runnable task, AzureTask.Modality modality) {
        this.runAndWait(new AzureTask<Void>(task, modality));
    }

    public final void runAndWait(String title, Runnable task, AzureTask.Modality modality) {
        this.runAndWait(new AzureTask<Void>(title, task, modality));
    }

    public final void runAndWait(AzureString title, Runnable task, AzureTask.Modality modality) {
        this.runAndWait(new AzureTask<Void>(title, task, modality));
    }

    public final void runAndWait(AzureTask<Void> task) {
        this.runInObservable(this::doRunAndWait, task).subscribe();
    }

    public final void runInBackground(String title, Runnable task) {
        this.runInBackground(new AzureTask<Void>(title, task));
    }

    public final void runInBackground(AzureString title, Runnable task) {
        this.runInBackground(new AzureTask<Void>(title, task));
    }

    public final void runInBackground(String title, Callable<Void> task) {
        this.runInBackground(new AzureTask<Void>(title, task));
    }

    public final void runInBackground(AzureString title, Callable<Void> task) {
        this.runInBackground(new AzureTask<Void>(title, task));
    }

    public final void runInBackground(String title, boolean cancellable, Runnable task) {
        this.runInBackground(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInBackground(AzureString title, boolean cancellable, Runnable task) {
        this.runInBackground(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInBackground(String title, boolean cancellable, Callable<Void> task) {
        this.runInBackground(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInBackground(AzureString title, boolean cancellable, Callable<Void> task) {
        this.runInBackground(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInBackground(AzureTask<Void> task) {
        this.runInObservable(this::doRunInBackground, task).subscribe();
    }

    public final void runInModal(String title, Runnable task) {
        this.runInModal(new AzureTask<Void>(title, task));
    }

    public final void runInModal(AzureString title, Runnable task) {
        this.runInModal(new AzureTask<Void>(title, task));
    }

    public final void runInModal(String title, Callable<Void> task) {
        this.runInModal(new AzureTask<Void>(title, task));
    }

    public final void runInModal(AzureString title, Callable<Void> task) {
        this.runInModal(new AzureTask<Void>(title, task));
    }

    public final void runInModal(String title, boolean cancellable, Runnable task) {
        this.runInModal(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInModal(AzureString title, boolean cancellable, Runnable task) {
        this.runInModal(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInModal(String title, boolean cancellable, Callable<Void> task) {
        this.runInModal(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInModal(AzureString title, boolean cancellable, Callable<Void> task) {
        this.runInModal(new AzureTask<Void>(null, title, cancellable, task));
    }

    public final void runInModal(AzureTask<Void> task) {
        this.runInObservable(this::doRunInModal, task).subscribe();
    }

    public final Observable<Void> readAsObservable(Runnable task) {
        return this.readAsObservable(new AzureTask(task));
    }

    public final Observable<Void> readAsObservable(String title, Runnable task) {
        return this.readAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> readAsObservable(AzureString title, Runnable task) {
        return this.readAsObservable(new AzureTask(title, task));
    }

    public final <T> Observable<T> readAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRead, task);
    }

    public final Observable<Void> writeAsObservable(Runnable task) {
        return this.writeAsObservable(new AzureTask(task));
    }

    public final Observable<Void> writeAsObservable(String title, Runnable task) {
        return this.writeAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> writeAsObservable(AzureString title, Runnable task) {
        return this.writeAsObservable(new AzureTask(title, task));
    }

    public final <T> Observable<T> writeAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doWrite, task);
    }

    public final Observable<Void> runImmediatelyAsObservable(Runnable task) {
        return this.runImmediatelyAsObservable(new AzureTask(task));
    }

    public final <T> Observable<T> runImmediatelyAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRunImmediately, task);
    }

    public final Observable<Void> runLaterAsObservable(Runnable task) {
        return this.runLaterAsObservable(new AzureTask(task));
    }

    public final Observable<Void> runLaterAsObservable(String title, Runnable task) {
        return this.runLaterAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> runLaterAsObservable(AzureString title, Runnable task) {
        return this.runLaterAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> runLaterAsObservable(Runnable task, AzureTask.Modality modality) {
        return this.runLaterAsObservable(new AzureTask(task, modality));
    }

    public final Observable<Void> runLaterAsObservable(String title, Runnable task, AzureTask.Modality modality) {
        return this.runLaterAsObservable(new AzureTask(title, task, modality));
    }

    public final Observable<Void> runLaterAsObservable(AzureString title, Runnable task, AzureTask.Modality modality) {
        return this.runLaterAsObservable(new AzureTask(title, task, modality));
    }

    public final <T> Observable<T> runLaterAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRunLater, task);
    }

    public final Observable<Void> runOnPooledThreadAsObservable(Runnable task) {
        return this.runOnPooledThreadAsObservable(new AzureTask(task));
    }

    public final <T> Observable<T> runOnPooledThreadAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRunOnPooledThread, task);
    }

    public final Observable<Void> runAndWaitAsObservable(Runnable task) {
        return this.runAndWaitAsObservable(new AzureTask(task));
    }

    public final Observable<Void> runAndWaitAsObservable(String title, Runnable task) {
        return this.runAndWaitAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> runAndWaitAsObservable(AzureString title, Runnable task) {
        return this.runAndWaitAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> runAndWaitAsObservable(Runnable task, AzureTask.Modality modality) {
        return this.runAndWaitAsObservable(new AzureTask(task, modality));
    }

    public final Observable<Void> runAndWaitAsObservable(String title, Runnable task, AzureTask.Modality modality) {
        return this.runAndWaitAsObservable(new AzureTask(title, task, modality));
    }

    public final Observable<Void> runAndWaitAsObservable(AzureString title, Runnable task, AzureTask.Modality modality) {
        return this.runAndWaitAsObservable(new AzureTask(title, task, modality));
    }

    public final <T> Observable<T> runAndWaitAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRunAndWait, task);
    }

    public final Observable<Void> runInBackgroundAsObservable(String title, Runnable task) {
        return this.runInBackgroundAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> runInBackgroundAsObservable(AzureString title, Runnable task) {
        return this.runInBackgroundAsObservable(new AzureTask(title, task));
    }

    public final <T> Observable<T> runInBackgroundAsObservable(String title, Callable<T> task) {
        return this.runInBackgroundAsObservable(new AzureTask<T>(title, task));
    }

    public final <T> Observable<T> runInBackgroundAsObservable(AzureString title, Callable<T> task) {
        return this.runInBackgroundAsObservable(new AzureTask<T>(title, task));
    }

    public final Observable<Void> runInBackgroundAsObservable(String title, boolean cancellable, Runnable task) {
        return this.runInBackgroundAsObservable(new AzureTask(null, title, cancellable, task));
    }

    public final Observable<Void> runInBackgroundAsObservable(AzureString title, boolean cancellable, Runnable task) {
        return this.runInBackgroundAsObservable(new AzureTask(null, title, cancellable, task));
    }

    public final <T> Observable<T> runInBackgroundAsObservable(String title, boolean cancellable, Callable<T> task) {
        return this.runInBackgroundAsObservable(new AzureTask<T>(null, title, cancellable, task));
    }

    public final <T> Observable<T> runInBackgroundAsObservable(AzureString title, boolean cancellable, Callable<T> task) {
        return this.runInBackgroundAsObservable(new AzureTask<T>(null, title, cancellable, task));
    }

    public final <T> Observable<T> runInBackgroundAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRunInBackground, task);
    }

    public final Observable<Void> runInModalAsObservable(String title, Runnable task) {
        return this.runInModalAsObservable(new AzureTask(title, task));
    }

    public final Observable<Void> runInModalAsObservable(AzureString title, Runnable task) {
        return this.runInModalAsObservable(new AzureTask(title, task));
    }

    public final <T> Observable<T> runInModalAsObservable(String title, Callable<T> task) {
        return this.runInModalAsObservable(new AzureTask<T>(title, task));
    }

    public final <T> Observable<T> runInModalAsObservable(AzureString title, Callable<T> task) {
        return this.runInModalAsObservable(new AzureTask<T>(title, task));
    }

    public final Observable<Void> runInModalAsObservable(String title, boolean cancellable, Runnable task) {
        return this.runInModalAsObservable(new AzureTask(null, title, cancellable, task));
    }

    public final Observable<Void> runInModalAsObservable(AzureString title, boolean cancellable, Runnable task) {
        return this.runInModalAsObservable(new AzureTask(null, title, cancellable, task));
    }

    public final <T> Observable<T> runInModalAsObservable(String title, boolean cancellable, Callable<T> task) {
        return this.runInModalAsObservable(new AzureTask<T>(null, title, cancellable, task));
    }

    public final <T> Observable<T> runInModalAsObservable(AzureString title, boolean cancellable, Callable<T> task) {
        return this.runInModalAsObservable(new AzureTask<T>(null, title, cancellable, task));
    }

    public final <T> Observable<T> runInModalAsObservable(AzureTask<T> task) {
        return this.runInObservable(this::doRunInModal, task);
    }

    private <T> Observable<T> runInObservable(BiConsumer<? super Runnable, ? super AzureTask<T>> consumer, AzureTask<T> task) {
        OperationThreadContext context = OperationThreadContext.current().derive();
        return Observable.create(emitter -> {
            AzureTelemeter.afterCreate(task);
            Runnable t = () -> context.run(() -> {
                try {
                    Object result = AzureOperationAspect.execute(task, null);
                    emitter.onNext(result);
                }
                catch (Throwable e) {
                    emitter.onError(e);
                    return;
                }
                emitter.onCompleted();
            });
            consumer.accept(t, task);
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER);
    }

    protected abstract void doRead(Runnable var1, AzureTask<?> var2);

    protected abstract void doWrite(Runnable var1, AzureTask<?> var2);

    protected void doRunImmediately(Runnable runnable, AzureTask<?> task) {
        runnable.run();
    }

    protected abstract void doRunLater(Runnable var1, AzureTask<?> var2);

    protected abstract void doRunOnPooledThread(Runnable var1, AzureTask<?> var2);

    protected abstract void doRunAndWait(Runnable var1, AzureTask<?> var2);

    protected abstract void doRunInBackground(Runnable var1, AzureTask<?> var2);

    protected abstract void doRunInModal(Runnable var1, AzureTask<?> var2);
}

