/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.AzService;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.netty.http.client.HttpClient;

public abstract class AbstractAzServiceSubscription<T extends AbstractAzResource<T, AzResource.None, R>, R>
extends AbstractAzResource<T, AzResource.None, R> {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected AbstractAzServiceSubscription(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, AzResource.None, R> module) {
        super(name, "${rg}", module);
    }

    @AzureOperation(name="azure/resource.list_supported_regions.type", params={"resourceType"})
    public List<Region> listSupportedRegions(@Nonnull String resourceType) {
        String string = resourceType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            String provider = this.getService().getName();
            String subscriptionId = this.getSubscriptionId();
            List<Region> allRegionList = Azure.az(IAzureAccount.class).listRegions(subscriptionId);
            ArrayList<Region> result = new ArrayList<Region>();
            ResourceManager resourceManager = this.getResourceManager();
            ((Provider)resourceManager.providers().getByName(provider)).resourceTypes().stream().filter(type -> StringUtils.equalsIgnoreCase((CharSequence)type.resourceType(), (CharSequence)resourceType)).findAny().map(ProviderResourceType::locations).ifPresent(list -> result.addAll(list.stream().map(Region::fromName).filter(allRegionList::contains).collect(Collectors.toList())));
            List<Region> list2 = result.isEmpty() ? allRegionList : result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return list2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nonnull
    protected String loadStatus(@Nonnull R remote) {
        return "OK";
    }

    @Nonnull
    public AzService getService() {
        return (AzService)((Object)this.getModule());
    }

    @Override
    @Nonnull
    public String getFullResourceType() {
        return this.getService().getName();
    }

    @Nonnull
    public ResourceManager getResourceManager() {
        String subscriptionId = this.getSubscriptionId();
        return AbstractAzServiceSubscription.getResourceManager(subscriptionId);
    }

    @Nonnull
    public static ResourceManager getResourceManager(@Nonnull String subscriptionId) {
        IAccount account = Azure.az(IAzureAccount.class).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logDetailLevel = config.getLogLevel() == null ? HttpLogDetailLevel.NONE : HttpLogDetailLevel.valueOf((String)config.getLogLevel());
        AzureProfile azureProfile = new AzureProfile(account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy(userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ((ResourceManager.Configurable)((ResourceManager.Configurable)((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withLogLevel(logDetailLevel)).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy(userAgent))).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId);
    }

    @Nonnull
    public static HttpPipelinePolicy getUserAgentPolicy(@Nonnull String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }

    @Nonnull
    public static com.azure.core.http.HttpClient getDefaultHttpClient() {
        return HttpClientHolder.getHttpClient();
    }

    static {
        AbstractAzServiceSubscription.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAzServiceSubscription.java", AbstractAzServiceSubscription.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listSupportedRegions", "com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription", "java.lang.String", "resourceType", "", "java.util.List"), 49);
    }

    public static class HttpClientHolder {
        private static com.azure.core.http.HttpClient defaultHttpClient = null;

        @Nonnull
        private static synchronized com.azure.core.http.HttpClient getHttpClient() {
            DefaultAddressResolverGroup resolverGroup;
            if (defaultHttpClient != null) {
                return defaultHttpClient;
            }
            ProxyOptions proxyOptions = null;
            AzureConfiguration config = Azure.az().config();
            if (StringUtils.isNotBlank((CharSequence)config.getProxySource())) {
                proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(config.getHttpProxyHost(), config.getHttpProxyPort()));
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getProxyUsername(), config.getProxyPassword()})) {
                    proxyOptions.setCredentials(config.getProxyUsername(), config.getProxyPassword());
                }
                resolverGroup = NoopAddressResolverGroup.INSTANCE;
            } else {
                resolverGroup = DefaultAddressResolverGroup.INSTANCE;
            }
            HttpClient nettyHttpClient = (HttpClient)HttpClient.create().resolver((AddressResolverGroup)resolverGroup);
            if (Objects.nonNull(config.getSslContext())) {
                nettyHttpClient = nettyHttpClient.secure(sslConfig -> sslConfig.sslContext((SslContext)new JdkSslContext(config.getSslContext(), true, ClientAuth.NONE)));
            }
            NettyAsyncHttpClientBuilder builder = new NettyAsyncHttpClientBuilder(nettyHttpClient);
            Optional.ofNullable(proxyOptions).map(arg_0 -> ((NettyAsyncHttpClientBuilder)builder).proxy(arg_0));
            defaultHttpClient = builder.build();
            return defaultHttpClient;
        }
    }
}

