/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.bundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureBundle {
    private final ResourceBundle bundle;

    public AzureBundle(@Nonnull String bundleName) {
        this.bundle = AzureBundle.getBundle(bundleName, this.getClass());
    }

    public AzureBundle(@Nonnull String bundleName, Class<?> clazz) {
        this.bundle = AzureBundle.getBundle(bundleName, clazz);
    }

    @Nonnull
    public String getMessage(@Nonnull String key, Object ... params) {
        String pattern = this.getPattern(key);
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return String.format("!%s!", key);
        }
        try {
            return MessageFormat.format(pattern, params);
        }
        catch (IllegalArgumentException e) {
            return pattern;
        }
    }

    @Nullable
    public String getPattern(@Nonnull String key) {
        if (StringUtils.isBlank((CharSequence)key) || Objects.isNull(this.bundle)) {
            return null;
        }
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    @Nullable
    private static ResourceBundle getBundle(String bundleName, Class<?> clazz) {
        try {
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), clazz.getClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    public AzureBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

