/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.operation.OperationThreadContext;
import com.microsoft.azure.toolkit.lib.common.operation.SimpleOperation;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface Operation {
    public static final String UNKNOWN_NAME = "<unknown>.<unknown>";

    @Nonnull
    public String getExecutionId();

    @Nonnull
    public String getId();

    public Callable<?> getBody();

    @Nonnull
    public String getType();

    @Nullable
    public AzureString getDescription();

    public void setParent(Operation var1);

    @Nullable
    public Operation getParent();

    public OperationContext getContext();

    default public Operation getEffectiveParent() {
        Operation parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.getId().equals(UNKNOWN_NAME)) {
            return parent;
        }
        return parent.getEffectiveParent();
    }

    @Nullable
    default public Operation getActionParent() {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.getType(), (CharSequence[])new CharSequence[]{"user", "platform"})) {
            return this;
        }
        return Optional.ofNullable(this.getParent()).map(Operation::getActionParent).orElse(null);
    }

    @Nullable
    public static Operation current() {
        return OperationThreadContext.current().currentOperation();
    }

    public static void execute(@Nonnull AzureString title, @Nonnull String type, @Nonnull Callable<?> body, @Nullable Object source) {
        SimpleOperation operation = new SimpleOperation(title, body, type);
        AzureOperationAspect.execute(operation, source);
    }

    public static void execute(@Nonnull AzureString title, @Nonnull String type, @Nonnull Runnable body, @Nullable Object source) {
        SimpleOperation operation = new SimpleOperation(title, () -> {
            body.run();
            return null;
        }, type);
        AzureOperationAspect.execute(operation, source);
    }

    public static interface Type {
        public static final String USER = "user";
        public static final String PLATFORM = "platform";
        public static final String INTERNAL = "internal";
        public static final String AZURE = "azure";
        public static final String BOUNDARY = "boundary";
        public static final String UNKNOWN = "unknown";
    }
}

