/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;

public class AzureConfiguration {
    public static final List<String> DEFAULT_DOCUMENT_LABEL_FIELDS = Arrays.asList("name", "Name", "NAME", "ID", "UUID", "Id", "id", "uuid");
    private String logLevel;
    private String userAgent;
    private String cloud;
    private String machineId;
    private String product;
    private String version;
    private String sessionId;
    private String databasePasswordSaveType;
    private Boolean telemetryEnabled;
    private String functionCoreToolsPath;
    private String dotnetRuntimePath;
    private String storageExplorerPath;
    private String proxySource;
    private String httpProxyHost;
    private int httpProxyPort;
    private String proxyUsername;
    private String proxyPassword;
    @Nullable
    private String nonProxyHosts;
    @Nullable
    @JsonIgnore
    private SSLContext sslContext;
    private int pageSize = 99;
    private List<String> documentsLabelFields = new ArrayList<String>(DEFAULT_DOCUMENT_LABEL_FIELDS);
    private int monitorQueryRowNumber = 200;
    private boolean authPersistenceEnabled = true;
    private String eventHubsConsumerGroup = "$Default";
    private String azuritePath;
    private String azuriteWorkspace;
    private Boolean enableLeaseMode = false;
    private Boolean enablePreloading = false;

    public void setProxyInfo(ProxyInfo proxy) {
        this.setProxySource(proxy.getSource());
        this.setHttpProxyHost(proxy.getHost());
        this.setHttpProxyPort(proxy.getPort());
        this.setProxyUsername(proxy.getUsername());
        this.setProxyPassword(proxy.getPassword());
        this.setNonProxyHosts(proxy.getNonProxyHosts());
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getCloud() {
        return this.cloud;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getDatabasePasswordSaveType() {
        return this.databasePasswordSaveType;
    }

    public Boolean getTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public String getFunctionCoreToolsPath() {
        return this.functionCoreToolsPath;
    }

    public String getDotnetRuntimePath() {
        return this.dotnetRuntimePath;
    }

    public String getStorageExplorerPath() {
        return this.storageExplorerPath;
    }

    public String getProxySource() {
        return this.proxySource;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Nullable
    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Nullable
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<String> getDocumentsLabelFields() {
        return this.documentsLabelFields;
    }

    public int getMonitorQueryRowNumber() {
        return this.monitorQueryRowNumber;
    }

    public boolean isAuthPersistenceEnabled() {
        return this.authPersistenceEnabled;
    }

    public String getEventHubsConsumerGroup() {
        return this.eventHubsConsumerGroup;
    }

    public String getAzuritePath() {
        return this.azuritePath;
    }

    public String getAzuriteWorkspace() {
        return this.azuriteWorkspace;
    }

    public Boolean getEnableLeaseMode() {
        return this.enableLeaseMode;
    }

    public Boolean getEnablePreloading() {
        return this.enablePreloading;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setDatabasePasswordSaveType(String databasePasswordSaveType) {
        this.databasePasswordSaveType = databasePasswordSaveType;
    }

    public void setTelemetryEnabled(Boolean telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
    }

    public void setFunctionCoreToolsPath(String functionCoreToolsPath) {
        this.functionCoreToolsPath = functionCoreToolsPath;
    }

    public void setDotnetRuntimePath(String dotnetRuntimePath) {
        this.dotnetRuntimePath = dotnetRuntimePath;
    }

    public void setStorageExplorerPath(String storageExplorerPath) {
        this.storageExplorerPath = storageExplorerPath;
    }

    public void setProxySource(String proxySource) {
        this.proxySource = proxySource;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setNonProxyHosts(@Nullable String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    @JsonIgnore
    public void setSslContext(@Nullable SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setDocumentsLabelFields(List<String> documentsLabelFields) {
        this.documentsLabelFields = documentsLabelFields;
    }

    public void setMonitorQueryRowNumber(int monitorQueryRowNumber) {
        this.monitorQueryRowNumber = monitorQueryRowNumber;
    }

    public void setAuthPersistenceEnabled(boolean authPersistenceEnabled) {
        this.authPersistenceEnabled = authPersistenceEnabled;
    }

    public void setEventHubsConsumerGroup(String eventHubsConsumerGroup) {
        this.eventHubsConsumerGroup = eventHubsConsumerGroup;
    }

    public void setAzuritePath(String azuritePath) {
        this.azuritePath = azuritePath;
    }

    public void setAzuriteWorkspace(String azuriteWorkspace) {
        this.azuriteWorkspace = azuriteWorkspace;
    }

    public void setEnableLeaseMode(Boolean enableLeaseMode) {
        this.enableLeaseMode = enableLeaseMode;
    }

    public void setEnablePreloading(Boolean enablePreloading) {
        this.enablePreloading = enablePreloading;
    }
}

