/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.ExpressionUtils;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CacheableAspect {
    private static final Logger log = Logger.getLogger(CacheableAspect.class.getName());
    private static final CacheLoader<String, Cache<Object, Object>> loader = new CacheLoader<String, Cache<Object, Object>>(){

        public Cache<Object, Object> load(@Nonnull String key) {
            return CacheBuilder.newBuilder().softValues().expireAfterAccess(4L, TimeUnit.HOURS).build();
        }
    };
    private static final LoadingCache<String, Cache<Object, Object>> caches = CacheBuilder.newBuilder().softValues().expireAfterAccess(4L, TimeUnit.HOURS).build(loader);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ CacheableAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.cache.Cacheable * *..*.*(..))")
    public void cacheable() {
    }

    @Around(value="cacheable()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        MethodInvocation invocation = MethodInvocation.from((JoinPoint)point);
        Cacheable annotation = signature.getMethod().getAnnotation(Cacheable.class);
        String cacheName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.cacheName(), annotation.value()});
        String name = ExpressionUtils.render(cacheName, invocation);
        String key = ExpressionUtils.render(annotation.key(), invocation);
        if (Objects.isNull(name) || Objects.isNull(key)) {
            CacheableAspect.log.severe(String.format("invalid @Cacheable on method(%s)", signature.getName()));
            return point.proceed();
        }
        String condition = annotation.condition();
        boolean toUseCache = StringUtils.isBlank((CharSequence)condition) || ExpressionUtils.evaluate(condition, invocation, true);
        Cache cache = (Cache)CacheableAspect.caches.get((Object)name);
        if (toUseCache) {
            return this.getFromCache((Cache<Object, Object>)cache, key, point);
        }
        Object result = point.proceed();
        if (Objects.nonNull(result)) {
            cache.put((Object)key, Optional.of(result));
        }
        return result;
    }

    private Object getFromCache(Cache<Object, Object> cache, String key, ProceedingJoinPoint point) throws Throwable {
        Optional result = (Optional)cache.get((Object)key, () -> {
            try {
                return Optional.ofNullable(point.proceed());
            }
            catch (Throwable throwable) {
                return Optional.of(throwable);
            }
        });
        if (result.isPresent() && result.get() instanceof Throwable) {
            cache.invalidate((Object)key);
            throw (Throwable)result.get();
        }
        return result.orElse(null);
    }

    static {
        try {
            CacheableAspect.ajc$perSingletonInstance = new CacheableAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static CacheableAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.cache.CacheableAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

