/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationException;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationRef;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import java.util.Objects;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class AzureOperationAspect {
    private static final Logger log = Logger.getLogger(AzureOperationAspect.class.getName());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AzureOperationAspect ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.operation.AzureOperation * *..*.*(..))")
    public void operation() {
    }

    @Before(value="operation()")
    public void beforeEnter(JoinPoint point) {
        AzureOperationRef operation = AzureOperationAspect.toOperationRef(point);
        AzureTelemeter.beforeEnter(operation);
        AzureTaskContext.current().pushOperation(operation);
    }

    @AfterReturning(value="operation()")
    public void afterReturning(JoinPoint point) {
        AzureOperationRef current = AzureOperationAspect.toOperationRef(point);
        AzureOperationRef operation = (AzureOperationRef)AzureTaskContext.current().popOperation();
        AzureTelemeter.afterExit(operation);
        assert (Objects.equals(current, operation)) : String.format("popped operation[%s] is not the exiting operation[%s]", current, operation);
    }

    @AfterThrowing(pointcut="operation()", throwing="e")
    public void afterThrowing(JoinPoint point, Throwable e) throws Throwable {
        AzureOperationRef current = AzureOperationAspect.toOperationRef(point);
        AzureOperationRef operation = (AzureOperationRef)AzureTaskContext.current().popOperation();
        AzureTelemeter.onError(operation, e);
        assert (Objects.equals(current, operation)) : String.format("popped operation[%s] is not the operation[%s] throwing exception", current, operation);
        if (!(e instanceof RuntimeException)) {
            throw e;
        }
        throw new AzureOperationException(operation, e);
    }

    private static AzureOperationRef toOperationRef(JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Object[] args = point.getArgs();
        Object instance = point.getThis();
        return ((AzureOperationRef.AzureOperationRefBuilder)((AzureOperationRef.AzureOperationRefBuilder)((AzureOperationRef.AzureOperationRefBuilder)((AzureOperationRef.AzureOperationRefBuilder)AzureOperationRef.builder().instance(instance)).method(signature.getMethod())).paramNames(signature.getParameterNames())).paramValues(args)).build();
    }

    static {
        try {
            AzureOperationAspect.ajc$perSingletonInstance = new AzureOperationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static AzureOperationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

