/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.exception.AzureExceptionHandler;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AzureTaskContext {
    private static final Logger log = Logger.getLogger(AzureTaskContext.class.getName());
    private static final ThreadLocal<Node> context = new ThreadLocal();
    protected long threadId = -1L;
    protected final Deque<IAzureOperation> operations;

    private AzureTaskContext() {
        this.operations = new ArrayDeque<IAzureOperation>();
    }

    private AzureTaskContext(long threadId, Deque<IAzureOperation> operations) {
        this.operations = operations;
        this.threadId = threadId;
    }

    public Deque<IAzureOperation> getOperations() {
        return new ArrayDeque<IAzureOperation>(this.operations);
    }

    public static Deque<IAzureOperation> getContextOperations(Node node) {
        ArrayDeque<IAzureOperation> ops = new ArrayDeque<IAzureOperation>(node.operations);
        AzureTaskContext parent = node.parent;
        while (Objects.nonNull(parent)) {
            ops.addAll(parent.operations);
            if (!(parent instanceof Node)) break;
            parent = ((Node)parent).parent;
        }
        return ops;
    }

    public static Deque<IAzureOperation> getContextOperations() {
        return AzureTaskContext.getContextOperations(AzureTaskContext.current());
    }

    public static Node current() {
        Node ctxNode = context.get();
        if (Objects.isNull(ctxNode)) {
            ctxNode = new Node(null);
            context.set(ctxNode);
        }
        return ctxNode;
    }

    public static void run(Runnable runnable, Node context) {
        try {
            context.setup();
            Optional.ofNullable(context.getTask()).ifPresent(task -> {
                AzureTelemeter.beforeEnter(task);
                AzureTaskContext.current().pushOperation((IAzureOperation)task);
            });
            runnable.run();
        }
        catch (Throwable throwable) {
            AzureExceptionHandler.onRxException(throwable);
            Optional.ofNullable(context.getTask()).ifPresent(task -> AzureTelemeter.onError(task, throwable));
        }
        finally {
            Optional.ofNullable(context.getTask()).ifPresent(task -> {
                IAzureOperation popped = AzureTaskContext.current().popOperation();
                AzureTelemeter.afterExit(task);
                assert (Objects.equals(task, popped)) : String.format("popped op[%s] is not the exiting async task[%s]", popped, task);
            });
            context.dispose();
        }
    }

    public String getId() {
        return Utils.getId(this);
    }

    public static class Snapshot
    extends AzureTaskContext {
        private final Node origin;

        private Snapshot(@Nonnull Node origin) {
            super(origin.threadId, AzureTaskContext.getContextOperations(origin));
            this.origin = origin;
        }

        public String toString() {
            String id = this.getId();
            String orId = this.origin.getId();
            return String.format("{id: %s, threadId:%s, origin:%s}", id, this.threadId, orId);
        }

        public Node getOrigin() {
            return this.origin;
        }
    }

    public static class Node
    extends AzureTaskContext {
        private Boolean backgrounded = null;
        private AzureTaskContext parent;
        protected boolean disposed;
        private AzureTask<?> task;
        private boolean async = false;

        private Node(AzureTaskContext parent) {
            this.parent = parent;
        }

        public boolean isOrphan() {
            return Objects.isNull(this.parent);
        }

        public void pushOperation(IAzureOperation operation) {
            if (this.isOrphan()) {
                log.warning(String.format("orphan context[%s] is setup", this));
            }
            this.operations.push(operation);
        }

        @Nullable
        public IAzureOperation popOperation() {
            IAzureOperation popped = (IAzureOperation)this.operations.pop();
            if (this.isOrphan() && this.operations.isEmpty()) {
                context.remove();
                log.warning(String.format("orphan context[%s] is disposed", this));
            }
            return popped;
        }

        Node derive() {
            long threadId = Thread.currentThread().getId();
            Node current = AzureTaskContext.current();
            assert (this == current) : String.format("[threadId:%s] deriving context from context[%s] in context[%s].", threadId, this, current);
            if (this.disposed) {
                log.warning(String.format("[threadId:%s] deriving from a disposed context[%s]", threadId, this));
            }
            this.threadId = this.threadId > 0L ? this.threadId : threadId;
            Snapshot snapshot = new Snapshot(this);
            return new Node(snapshot);
        }

        private void setup() {
            Node current = AzureTaskContext.current();
            long threadId = Thread.currentThread().getId();
            assert (current.threadId == -1L || current.threadId == threadId) : String.format("[threadId:%s] illegal thread context[%s]", threadId, current);
            if (this.threadId > 0L || this.disposed) {
                log.warning(String.format("[threadId:%s] context[%s] already setup/disposed", threadId, this));
            }
            this.threadId = threadId;
            boolean bl = this.async = threadId != current.threadId;
            if (threadId == current.threadId) {
                this.parent = current;
            }
            context.set(this);
        }

        private void dispose() {
            Node current = AzureTaskContext.current();
            long threadId = Thread.currentThread().getId();
            assert (this == current && this.threadId == threadId) : String.format("[threadId:%s] disposing context[%s] in context[%s].", threadId, this, current);
            if (this.disposed) {
                log.warning(String.format("[threadId:%s] disposing a disposed context[%s].", threadId, this));
            }
            this.disposed = true;
            if (this.parent instanceof Node) {
                assert (this.threadId == this.parent.threadId) : String.format("current[%s].threadId != current.parent[%s].threadId", this, this.parent);
                assert (!this.async) : String.format("disposing async task context[%s](parent[%s]) in sync mode", this, this.parent);
                context.set((Node)this.parent);
            } else {
                assert (this.async) : String.format("disposing sync task context[%s](parent[%s]) in async mode", this, this.parent);
                if (this.threadId == this.parent.threadId) {
                    log.warning(String.format("[threadId:%s] thread/threadId is reused.", threadId));
                }
                context.remove();
            }
        }

        public String toString() {
            String id = this.getId();
            if (this.parent instanceof Snapshot) {
                String orId = ((Snapshot)this.parent).origin.getId();
                return String.format("{id: %s, threadId:%s, snapshot@parent.origin:%s, disposed:%s}", id, this.threadId, orId, this.disposed);
            }
            String prId = Optional.ofNullable(this.parent).map(AzureTaskContext::getId).orElse("/");
            return String.format("{id: %s, threadId:%s, parent:%s, disposed:%s}", id, this.threadId, prId, this.disposed);
        }

        public void setBackgrounded(Boolean backgrounded) {
            this.backgrounded = backgrounded;
        }

        public Boolean getBackgrounded() {
            return this.backgrounded;
        }

        public AzureTaskContext getParent() {
            return this.parent;
        }

        public AzureTask<?> getTask() {
            return this.task;
        }

        void setTask(AzureTask<?> task) {
            this.task = task;
        }
    }
}

