/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import com.microsoft.azure.toolkit.lib.common.telemetry.Telemetry;
import java.time.Instant;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureTelemeter {
    private static final String SERVICE_NAME = "serviceName";
    private static final String OPERATION_NAME = "operationName";
    private static final String TIMESTAMP = "timestamp";
    private static final String OP_ID = "op_id";
    private static final String OP_NAME = "op_name";
    private static final String OP_TYPE = "op_type";
    private static final String OP_ACTION = "op_action";
    private static final String OP_PARENT_ID = "op_parentId";
    private static final String OP_ACTION_CREATE = "CREATE";
    private static final String OP_ACTION_ENTER = "ENTER";
    private static final String OP_ACTION_EXIT = "EXIT";
    private static final String OP_ACTION_ERROR = "ERROR";
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_MSG = "message";
    private static final String ERROR_TYPE = "errorType";
    private static final String ERROR_CLASSNAME = "errorClassName";
    private static final String ERROR_STACKTRACE = "errorStackTrace";
    private static String eventNamePrefix;
    private static Map<String, String> commonProperties;
    private static TelemetryClient client;

    public static void afterCreate(IAzureOperation op) {
        Map<String, String> properties = AzureTelemeter.serialize(op);
        properties.put(TIMESTAMP, Instant.now().toString());
        properties.put(OP_ACTION, OP_ACTION_CREATE);
        AzureTelemeter.log(Telemetry.Type.INFO, properties);
    }

    public static void beforeEnter(IAzureOperation op) {
        Map<String, String> properties = AzureTelemeter.serialize(op);
        properties.put(TIMESTAMP, Instant.now().toString());
        properties.put(OP_ACTION, OP_ACTION_ENTER);
        AzureTelemeter.log(Telemetry.Type.OP_START, properties);
    }

    public static void afterExit(IAzureOperation op) {
        Map<String, String> properties = AzureTelemeter.serialize(op);
        properties.put(TIMESTAMP, Instant.now().toString());
        properties.put(OP_ACTION, OP_ACTION_EXIT);
        AzureTelemeter.log(Telemetry.Type.OP_END, properties);
    }

    public static void onError(IAzureOperation op, Throwable error) {
        Map<String, String> properties = AzureTelemeter.serialize(op);
        properties.put(TIMESTAMP, Instant.now().toString());
        properties.put(OP_ACTION, OP_ACTION_ERROR);
        AzureTelemeter.log(Telemetry.Type.ERROR, properties, error);
    }

    public static void log(Telemetry.Type type, Map<String, String> properties, Throwable e) {
        if (Objects.nonNull(e)) {
            properties.putAll(AzureTelemeter.serialize(e));
        }
        AzureTelemeter.log(type, properties);
    }

    public static void log(Telemetry.Type type, Map<String, String> properties) {
        if (client != null) {
            properties.putAll(AzureTelemeter.getCommonProperties());
            String eventName = AzureTelemeter.getEventNamePrefix() + "/" + type.name();
            client.trackEvent(eventName, properties, null);
            client.flush();
        }
    }

    @Nonnull
    private static Map<String, String> serialize(@Nonnull IAzureOperation op) {
        Deque<IAzureOperation> ctxOperations = AzureTaskContext.getContextOperations();
        Optional<IAzureOperation> parent = Optional.ofNullable(ctxOperations.peekFirst());
        HashMap<String, String> properties = new HashMap<String, String>();
        String name = op.getName().replaceAll("\\(.+\\)", "(***)");
        String[] parts = name.split("\\.");
        String[] compositeServiceName = parts[0].split("\\|");
        String mainServiceName = compositeServiceName[0];
        String operationName = compositeServiceName.length > 1 ? parts[1] + "_" + compositeServiceName[1] : parts[1];
        properties.put(SERVICE_NAME, mainServiceName);
        properties.put(OPERATION_NAME, operationName);
        properties.put(OP_ID, op.getId());
        properties.put(OP_PARENT_ID, parent.map(IAzureOperation::getId).orElse("/"));
        properties.put(OP_NAME, name);
        properties.put(OP_TYPE, op.getType());
        return properties;
    }

    @Nonnull
    private static HashMap<String, String> serialize(@Nonnull Throwable e) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ErrorType type = ErrorType.userError;
        properties.put(ERROR_CLASSNAME, e.getClass().getName());
        properties.put(ERROR_TYPE, type.name());
        properties.put(ERROR_MSG, e.getMessage());
        properties.put(ERROR_STACKTRACE, ExceptionUtils.getStackTrace((Throwable)e));
        return properties;
    }

    public static String getEventNamePrefix() {
        return eventNamePrefix;
    }

    public static void setEventNamePrefix(String eventNamePrefix) {
        AzureTelemeter.eventNamePrefix = eventNamePrefix;
    }

    public static Map<String, String> getCommonProperties() {
        return commonProperties;
    }

    public static void setCommonProperties(Map<String, String> commonProperties) {
        AzureTelemeter.commonProperties = commonProperties;
    }

    public static TelemetryClient getClient() {
        return client;
    }

    public static void setClient(TelemetryClient client) {
        AzureTelemeter.client = client;
    }

    private static enum ErrorType {
        userError,
        systemError,
        serviceError,
        toolError,
        unclassifiedError;

    }
}

