/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.client.utils.URIBuilder;
import reactor.core.publisher.Flux;

public interface StreamingLogSupport {
    default public Flux<String> streamingLogs(boolean follow) {
        return this.streamingLogs(follow, Collections.emptyMap());
    }

    default public Flux<String> streamingLogs(boolean follow, int tailLines) {
        return this.streamingLogs(follow, Collections.singletonMap("tailLines", String.valueOf(tailLines)));
    }

    default public Flux<String> streamingLogs(boolean follow, @Nonnull Map<String, String> p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sinceSeconds", String.valueOf(300));
            params.put("tailLines", String.valueOf(300));
            params.put("limitBytes", String.valueOf(0x100000));
            params.putAll(p);
            params.put("follow", String.valueOf(follow));
            HttpURLConnection connection = this.createLogStreamConnection(params);
            connection.connect();
            return Flux.create(fluxSink -> {
                try {
                    String line;
                    InputStream is = connection.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    while ((line = rd.readLine()) != null) {
                        fluxSink.next((Object)line);
                    }
                    rd.close();
                }
                catch (FileNotFoundException e) {
                    AzureMessager.getMessager().error("app/instance may be deactivated, please refresh and try again later.");
                }
                catch (IOException e) {
                    throw new AzureToolkitRuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new AzureToolkitRuntimeException(e);
        }
    }

    @Nonnull
    default public HttpURLConnection createLogStreamConnection(Map<String, String> params) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.getLogStreamEndpoint());
        params.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
        HttpURLConnection connection = (HttpURLConnection)uriBuilder.build().toURL().openConnection();
        connection.setRequestProperty("Authorization", this.getLogStreamAuthorization());
        connection.setReadTimeout(600000);
        connection.setConnectTimeout(3000);
        connection.setRequestMethod("GET");
        return connection;
    }

    default public String getLogStreamEndpoint() {
        throw new NotImplementedException();
    }

    default public String getLogStreamAuthorization() {
        throw new NotImplementedException();
    }
}

