/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzComponent;
import com.microsoft.azure.toolkit.lib.common.model.AzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Refreshable;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface AzResource
extends Refreshable,
AzComponent {
    public static final Action.Id<AzResource> CONNECT_RESOURCE = Action.Id.of("user/$resource.connect_resource.resource");
    public static final Action.Id<Object> CREATE_RESOURCE = Action.Id.of("user/$resource.create_resource.type");
    public static final Action.Id<AzResource> DEPLOY = Action.Id.of("user/$resource.deploy_resource.resource");
    public static final long CACHE_LIFETIME = 1800000L;
    public static final None NONE = new None();
    public static final String RESOURCE_GROUP_PLACEHOLDER = "${rg}";

    public boolean exists();

    @Override
    public void refresh();

    @Nonnull
    public AzResourceModule<?> getModule();

    @Override
    @Nonnull
    default public String getFullResourceType() {
        return this.getModule().getFullResourceType();
    }

    @Override
    @Nonnull
    default public String getResourceTypeName() {
        return this.getModule().getResourceTypeName();
    }

    @Nonnull
    default public String getSubscriptionId() {
        return this.getModule().getSubscriptionId();
    }

    @Nonnull
    default public String getResourceGroupName() {
        return ResourceId.fromString((String)this.getId()).resourceGroupName();
    }

    public void delete();

    @Nonnull
    default public Subscription getSubscription() {
        try {
            return Azure.az(IAzureAccount.class).account().getSubscription(this.getSubscriptionId());
        }
        catch (IllegalArgumentException e) {
            return new Subscription(this.getSubscriptionId());
        }
    }

    @Nonnull
    default public String getPortalUrl() {
        IAccount account = Azure.az(IAzureAccount.class).account();
        Subscription subscription = account.getSubscription(this.getSubscriptionId());
        return String.format("%s/#@%s/resource%s", account.getPortalUrl(), subscription.getTenantId(), this.getId());
    }

    @Nonnull
    public String getStatus();

    default public FormalStatus getFormalStatus() {
        String status = this.getStatus();
        return StringUtils.isBlank((CharSequence)status) ? FormalStatus.UNKNOWN : FormalStatus.dummyFormalize(status);
    }

    @Deprecated
    default public String name() {
        return this.getName();
    }

    @Deprecated
    default public String id() {
        return this.getId();
    }

    public static interface Status {
        public static final String PENDING = "Pending";
        public static final String CREATING = "Creating";
        public static final String DELETING = "Deleting";
        public static final String LOADING = "Loading";
        public static final String UPDATING = "Updating";
        public static final String SCALING = "Scaling";
        public static final String DEPLOYING = "Deploying";
        public static final String STARTING = "Starting";
        public static final String RESTARTING = "Restarting";
        public static final String STOPPING = "Stopping";
        public static final String ACTIVATING = "Activating";
        public static final String DEACTIVATING = "Deactivating";
        public static final String DELETED = "Deleted";
        public static final String ERROR = "Error";
        public static final String INACTIVE = "Inactive";
        public static final String RUNNING = "Running";
        public static final String OK = "OK";
        public static final String ONLINE = "Online";
        public static final String STOPPED = "Stopped";
        public static final String UNKNOWN = "Unknown";
    }

    public static interface Draft<T extends AzResource, R> {
        public String getName();

        public String getResourceGroupName();

        public AzResourceModule<T> getModule();

        default public T commit() {
            boolean existing = this.getModule().exists(this.getName(), this.getResourceGroupName());
            T result = existing ? this.getModule().update(this) : this.getModule().create(this);
            this.reset();
            return result;
        }

        public void reset();

        @Nonnull
        default public T createIfNotExist() {
            T origin = this.getModule().get(this.getName(), this.getResourceGroupName());
            if (Objects.isNull(origin) || !origin.exists()) {
                return this.getModule().create(this);
            }
            return origin;
        }

        @Nullable
        default public T updateIfExist() {
            T origin = this.getModule().get(this.getName(), this.getResourceGroupName());
            if (Objects.nonNull(origin) && origin.exists()) {
                return this.getModule().update(this);
            }
            return origin;
        }

        @Nonnull
        public R createResourceInAzure();

        default public T asResource() {
            return (T)((AzResource)((Object)this));
        }

        @Nonnull
        public R updateResourceInAzure(@Nonnull R var1);

        public boolean isModified();

        @Nullable
        public T getOrigin();
    }

    public static final class None
    extends AbstractAzResource<None, None, Void> {
        public static final String NONE = "$NONE$";
        private final String id = "$NONE$";
        private final String name = "$NONE$";
        private final String status = "$NONE$";
        private final String subscriptionId = "$NONE$";

        private None() {
            super(NONE, AzResource.RESOURCE_GROUP_PLACEHOLDER, AzResourceModule.NONE);
        }

        @Override
        @Nonnull
        public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public AbstractAzResourceModule<None, None, Void> getModule() {
            return AzResourceModule.NONE;
        }

        @Override
        @Nonnull
        public String getFullResourceType() {
            return NONE;
        }

        @Override
        @Nonnull
        public String getResourceTypeName() {
            return NONE;
        }

        @Override
        @Nonnull
        protected String loadStatus(@Nonnull Void remote) {
            return "OK";
        }

        @Override
        @Nonnull
        public String getStatus() {
            return "OK";
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof None;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public String getId() {
            Objects.requireNonNull(this);
            return NONE;
        }

        @Override
        public String getName() {
            Objects.requireNonNull(this);
            return NONE;
        }

        @Override
        public String getSubscriptionId() {
            Objects.requireNonNull(this);
            return NONE;
        }
    }

    public static enum FormalStatus {
        RUNNING,
        STOPPED,
        FAILED,
        DELETED,
        UNKNOWN,
        WRITING,
        READING,
        CREATING,
        DELETING;

        private static final HashSet<String> runningStatus;
        private static final HashSet<String> stoppedStatus;
        private static final HashSet<String> failedStatus;
        private static final HashSet<String> writingStatus;
        private static final HashSet<String> readingStatus;
        private static final HashSet<String> deletingStatus;
        private static final HashSet<String> deletedStatus;

        public static FormalStatus dummyFormalize(String status) {
            if (runningStatus.contains(status = status.toLowerCase())) {
                return RUNNING;
            }
            if (stoppedStatus.contains(status)) {
                return STOPPED;
            }
            if (failedStatus.contains(status)) {
                return FAILED;
            }
            if ("creating".equals(status)) {
                return CREATING;
            }
            if (writingStatus.contains(status)) {
                return WRITING;
            }
            if (readingStatus.contains(status)) {
                return READING;
            }
            if (deletingStatus.contains(status)) {
                return DELETING;
            }
            if (deletedStatus.contains(status)) {
                return DELETED;
            }
            return UNKNOWN;
        }

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isStopped() {
            return this == STOPPED;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isDeleted() {
            return this == DELETED;
        }

        public boolean isCreating() {
            return this == CREATING;
        }

        public boolean isDeleting() {
            return this == DELETING;
        }

        public boolean isWriting() {
            return this == WRITING || this.isCreating();
        }

        public boolean isReading() {
            return this == READING;
        }

        public boolean isWaiting() {
            return this.isWriting() || this.isDeleting() || this.isCreating() || this.isReading();
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isWritable() {
            return this.isConnected() && !this.isFailed() && !this.isWriting();
        }

        public boolean isConnected() {
            return !this.isDeleted() && !this.isUnknown() && !this.isCreating() && !this.isDeleting();
        }

        static {
            runningStatus = Sets.newHashSet((Object[])new String[]{"running", "success", "succeeded", "ready", "ok", "online", "healthy", "active"});
            stoppedStatus = Sets.newHashSet((Object[])new String[]{"stopped", "deallocated", "deprovisioned", "disabled"});
            failedStatus = Sets.newHashSet((Object[])new String[]{"failed", "error", "unhealthy"});
            writingStatus = Sets.newHashSet((Object[])new String[]{"writing", "pending", "processing", "updating", "starting", "stopping", "activating", "deactivating", "restarting", "scaling", "deprovisioning", "provisioning", "deploying"});
            readingStatus = Sets.newHashSet((Object[])new String[]{"reading", "loading", "refreshing"});
            deletingStatus = Sets.newHashSet((Object[])new String[]{"deleting"});
            deletedStatus = Sets.newHashSet((Object[])new String[]{"deleted", "removed", "disconnected"});
        }
    }
}

