/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.ActionGroup;
import com.microsoft.azure.toolkit.lib.common.action.ActionInstance;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManagerProvider;
import com.microsoft.azure.toolkit.lib.common.action.IActionGroup;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AzureActionManager {
    public <D> String getPlace(ActionInstance<D> action) {
        return "empty";
    }

    public static AzureActionManager getInstance() {
        return Holder.instance;
    }

    public abstract <D> void registerAction(Action<D> var1);

    public <D> void registerAction(Action.Id<D> id, Consumer<D> action) {
        this.registerAction(new Action<D>(id).withHandler(action));
    }

    public abstract <D> Action<D> getAction(Action.Id<D> var1);

    public abstract void registerGroup(String var1, ActionGroup var2);

    public abstract IActionGroup getGroup(String var1);

    public <D> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull Predicate<D> condition, @Nonnull Consumer<D> handler) {
        Action<D> action = this.getAction(id);
        action.withHandler(condition, handler);
    }

    public <D> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull Consumer<D> handler) {
        Action<Object> action = this.getAction(id);
        action.withHandler(o -> true, handler);
    }

    public <D, E> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull BiPredicate<D, E> condition, @Nonnull BiConsumer<D, E> handler) {
        Action<D> action = this.getAction(id);
        action.withHandler(condition, handler);
    }

    public <D, E> void registerHandler(@Nonnull Action.Id<D> id, @Nonnull BiConsumer<D, E> handler) {
        Action<Object> action = this.getAction(id);
        action.withHandler((r, e) -> true, handler);
    }

    @Nonnull
    public Shortcuts getIDEDefaultShortcuts() {
        return new Shortcuts(){};
    }

    public static class DummyOpenUrlAction
    extends Action<String> {
        private DummyOpenUrlAction() {
            super(Action.OPEN_URL);
        }

        public String toString(IAzureMessage.ValueDecorator decorator) {
            IView.Label view = this.getView(this.target);
            return String.format("[%s](%s)", view.getLabel(), decorator.decorateValue(this.target, null));
        }
    }

    public static class DummyActionManager
    extends AzureActionManager {
        @Override
        public <D> void registerAction(Action<D> action) {
        }

        @Override
        public <D> Action<D> getAction(Action.Id<D> id) {
            if (id == Action.OPEN_URL) {
                return new DummyOpenUrlAction();
            }
            return null;
        }

        @Override
        public void registerGroup(String id, ActionGroup group) {
        }

        @Override
        public ActionGroup getGroup(String id) {
            return null;
        }
    }

    public static interface Shortcuts {
        default public Object add() {
            return null;
        }

        default public Object delete() {
            return null;
        }

        default public Object view() {
            return null;
        }

        default public Object edit() {
            return null;
        }

        default public Object refresh() {
            return null;
        }

        default public Object start() {
            return null;
        }

        default public Object stop() {
            return null;
        }

        default public Object restart() {
            return null;
        }

        default public Object deploy() {
            return null;
        }

        default public Object copy() {
            return null;
        }

        default public Object paste() {
            return null;
        }
    }

    private static final class Holder {
        private static final AzureActionManager instance = Holder.loadActionManager();

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static AzureActionManager loadActionManager() {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(AzureActionManager.class.getClassLoader());
                ServiceLoader<AzureActionManagerProvider> loader = ServiceLoader.load(AzureActionManagerProvider.class, AzureActionManager.class.getClassLoader());
                Iterator<AzureActionManagerProvider> iterator = loader.iterator();
                if (iterator.hasNext()) {
                    AzureActionManager azureActionManager = iterator.next().getActionManager();
                    return azureActionManager;
                }
                DummyActionManager dummyActionManager = new DummyActionManager();
                return dummyActionManager;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }
}

