/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.models.GenericResources;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.resource.GenericResource;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericResourceModule
extends AbstractAzResourceModule<GenericResource, ResourceGroup, HasId> {
    public static final String NAME = "genericResources";

    public GenericResourceModule(@Nonnull ResourceGroup parent) {
        super(NAME, parent);
    }

    @Nullable
    public GenericResources getClient() {
        return Optional.ofNullable(((ResourcesServiceSubscription)((ResourceGroup)this.parent).getParent()).getRemote()).map(ResourceManager::genericResources).orElse(null);
    }

    @Override
    @Nonnull
    protected Iterator<? extends ContinuablePage<String, HasId>> loadResourcePagesFromAzure() {
        GenericResources resources = Objects.requireNonNull(this.getClient());
        return resources.listByResourceGroup(((ResourceGroup)this.parent).getName()).streamByPage(GenericResourceModule.getPageSize()).map(p -> new ItemPage<HasId>(p.getValue().stream().filter(r -> Objects.isNull(ResourceId.fromString((String)r.id()).parent())).map(a -> a))).iterator();
    }

    @Override
    @Nonnull
    public String toResourceId(@Nonnull String resourceId, @Nullable String resourceGroup) {
        return resourceId;
    }

    @Override
    @Nonnull
    protected GenericResource newResource(@Nonnull HasId r) {
        return new GenericResource(r, this);
    }

    @Override
    @Nonnull
    protected GenericResource newResource(@Nonnull String resourceId, @Nullable String resourceGroupName) {
        return new GenericResource(resourceId, this);
    }

    @Override
    @Nonnull
    public GenericResource newResource(@Nonnull AbstractAzResource<?, ?, ?> concrete) {
        return new GenericResource(concrete, this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Generic resource";
    }
}

