/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.exception;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.management.exception.ManagementException;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureToolkitRuntimeException
extends RuntimeException {
    private final Object[] actions;
    @Nullable
    private final String tips;

    public AzureToolkitRuntimeException(@Nonnull Throwable cause) {
        this(null, cause);
    }

    public AzureToolkitRuntimeException(@Nonnull String cause) {
        this(cause, (Object[])null);
    }

    public AzureToolkitRuntimeException(String error, @Nonnull Throwable cause) {
        this(error, cause, (Object[])null);
    }

    public AzureToolkitRuntimeException(@Nonnull String cause, Object ... actions) {
        super(cause);
        this.actions = actions;
        this.tips = null;
    }

    public AzureToolkitRuntimeException(String error, @Nonnull Throwable cause, Object ... actions) {
        super(error, cause);
        this.actions = actions;
        this.tips = null;
    }

    public AzureToolkitRuntimeException(@Nonnull Throwable cause, @Nonnull String tips) {
        this(null, cause, tips);
    }

    public AzureToolkitRuntimeException(@Nonnull String cause, @Nonnull String tips) {
        this(cause, tips, (Object[])null);
    }

    public AzureToolkitRuntimeException(String error, @Nonnull Throwable cause, @Nonnull String tips) {
        this(error, cause, tips, (Object[])null);
    }

    public AzureToolkitRuntimeException(@Nonnull String cause, @Nonnull String tips, Object ... actions) {
        super(cause);
        this.actions = actions;
        this.tips = tips;
    }

    public AzureToolkitRuntimeException(String error, @Nonnull Throwable cause, @Nonnull String tips, Object ... actions) {
        super(error, cause);
        this.actions = actions;
        this.tips = tips;
    }

    public static RuntimeException addDefaultActions(RuntimeException e) {
        if (!(e instanceof AzureToolkitRuntimeException)) {
            Action.Id[] defaultActions = null;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof ManagementException) {
                int errorCode = Optional.ofNullable((ManagementException)rootCause).map(HttpResponseException::getResponse).map(HttpResponse::getStatusCode).orElse(0);
                if (errorCode == 403) {
                    defaultActions = new Action.Id[]{Action.SELECT_SUBS};
                } else if (errorCode == 401) {
                    defaultActions = new Action.Id[]{Action.AUTHENTICATE};
                }
            }
            if (Objects.nonNull(defaultActions)) {
                throw new AzureToolkitRuntimeException(e.getMessage(), (Throwable)e, (Object[])defaultActions);
            }
        }
        return e;
    }

    public Object[] getActions() {
        return this.actions;
    }

    @Nullable
    public String getTips() {
        return this.tips;
    }
}

