/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cache1<T> {
    private static final Logger log = LoggerFactory.getLogger(Cache1.class);
    private static final ThreadLocal<Stack<Cache1<?>>> caching = ThreadLocal.withInitial(Stack::new);
    private static final String KEY = "CACHE1_KEY";
    @Nonnull
    private final LoadingCache<String, Optional<T>> cache;
    @Nonnull
    private final Supplier<T> supplier;
    @Nonnull
    private final AtomicReference<String> status = new AtomicReference();
    private BiConsumer<T, T> onNewValue = (n, o) -> {};
    private Consumer<String> onNewStatus = s -> {};
    private T latest = null;

    public Cache1(@Nonnull Supplier<T> supplier) {
        this.supplier = supplier;
        this.cache = Caffeine.newBuilder().build(key -> this.load());
    }

    public Cache1<T> onValueChanged(BiConsumer<T, T> onNewValue) {
        this.onNewValue = onNewValue;
        return this;
    }

    public Cache1<T> onStatusChanged(Consumer<String> onNewStatus) {
        this.onNewStatus = onNewStatus;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Optional<T> load() {
        if (AzureTaskManager.getInstance().isUIThread()) {
            return Optional.ofNullable(this.latest);
        }
        String originalStatus = "Loading";
        try {
            caching.get().push(this);
            this.setStatus("Loading");
            T oldValue = this.latest;
            this.latest = this.supplier.get();
            T newValue = this.latest;
            Optional<T> result = Optional.ofNullable(newValue);
            if (this.compareAndSetStatus("Loading", "OK")) {
                AzureTaskManager.getInstance().runOnPooledThread(() -> this.onNewValue.accept(newValue, oldValue));
                Optional<T> optional = result;
                return optional;
            }
        }
        catch (Throwable e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (!(root instanceof InterruptedException) && this.compareAndSetStatus("Loading", "Unknown")) {
                throw e;
            }
        }
        finally {
            caching.get().pop();
        }
        this.compareAndSetStatus("Loading", null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Optional<T> update(@Nonnull Callable<T> body, String status, T oldValue) {
        String originalStatus = Optional.ofNullable(status).orElse("Updating");
        try {
            caching.get().push(this);
            this.setStatus(originalStatus);
            this.latest = body.call();
            T value = this.latest;
            Optional<Object> result = Optional.ofNullable(value);
            Object newValue = result.orElse(null);
            if (this.compareAndSetStatus(originalStatus, "OK")) {
                if (!Objects.equals(newValue, oldValue)) {
                    AzureTaskManager.getInstance().runOnPooledThread(() -> this.onNewValue.accept(newValue, oldValue));
                }
                Optional<Object> optional = result;
                return optional;
            }
        }
        catch (Throwable e) {
            if (this.compareAndSetStatus(originalStatus, "Unknown")) {
                throw e instanceof AzureToolkitRuntimeException ? (AzureToolkitRuntimeException)e : new AzureToolkitRuntimeException(e);
            }
        }
        finally {
            caching.get().pop();
        }
        this.compareAndSetStatus(originalStatus, null);
        return null;
    }

    @Nullable
    public T update(@Nonnull Callable<T> body, String status) {
        if (AzureTaskManager.getInstance().isUIThread()) {
            log.debug("!!!!!!!!!!!!!!!!! Calling Cache1.update() in UI thread may block UI.");
            log.debug(Arrays.stream(Thread.currentThread().getStackTrace()).map(t -> "\tat " + t).collect(Collectors.joining("\n")));
            return this.latest;
        }
        if (caching.get().contains(this)) {
            return body.call();
        }
        T oldValue = this.getIfPresent();
        this.cache.invalidate((Object)KEY);
        try {
            return Optional.ofNullable(this.cache.get((Object)KEY, key -> this.update(body, status, oldValue))).flatMap(o -> o).orElse(null);
        }
        catch (Throwable e) {
            throw e.getCause();
        }
    }

    @Nullable
    public T update(@Nonnull Runnable body, String status) {
        return (T)this.update(() -> {
            body.run();
            return this.supplier.get();
        }, status);
    }

    @Nullable
    public T getIfPresent() {
        return this.getIfPresent(false);
    }

    @Nullable
    public T getIfPresent(boolean loadIfAbsent) {
        if (caching.get().contains(this)) {
            return this.latest;
        }
        Optional opt = (Optional)this.cache.getIfPresent((Object)KEY);
        if (opt == null) {
            if (loadIfAbsent && StringUtils.equalsAnyIgnoreCase((CharSequence)this.getStatus(), (CharSequence[])new CharSequence[]{"OK", "Unknown", null})) {
                AzureTaskManager.getInstance().runOnPooledThread(this::get);
            }
            return this.latest;
        }
        return opt.orElse(null);
    }

    @Nullable
    public T get() {
        if (AzureTaskManager.getInstance().isUIThread()) {
            log.debug("!!!!!!!!!!!!!!!!! Calling Cache1.get() in UI thread may block UI.");
            log.debug(Arrays.stream(Thread.currentThread().getStackTrace()).map(t -> "\tat " + t).collect(Collectors.joining("\n")));
            return this.latest;
        }
        if (caching.get().contains(this)) {
            return this.latest;
        }
        try {
            Optional value = (Optional)this.cache.get((Object)KEY);
            if (value == null) {
                return this.latest;
            }
            return value.orElse(null);
        }
        catch (IllegalStateException e) {
            return this.latest;
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    public void invalidate() {
        if (caching.get().contains(this) || this.isProcessing()) {
            this.status.set(null);
            return;
        }
        if (this.status.compareAndSet("OK", null) || this.status.compareAndSet("Unknown", null)) {
            this.cache.invalidateAll();
        }
    }

    private boolean compareAndSetStatus(String o, String n) {
        if (this.status.compareAndSet(o, n)) {
            Optional.ofNullable(this.onNewStatus).ifPresent(c -> c.accept(this.status.get()));
            return true;
        }
        return false;
    }

    private void setStatus(String n) {
        this.status.set(n);
        Optional.ofNullable(this.onNewStatus).ifPresent(c -> c.accept(this.status.get()));
    }

    public String getStatus() {
        return this.status.get();
    }

    private boolean isProcessing() {
        return !StringUtils.equalsAnyIgnoreCase((CharSequence)this.getStatus(), (CharSequence[])new CharSequence[]{"OK", "Unknown"});
    }

    public static interface Status {
        public static final String LOADING = "Loading";
        public static final String UPDATING = "Updating";
        public static final String OK = "OK";
        public static final String UNKNOWN = "Unknown";
    }
}

