/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.google.common.collect.ImmutableMap;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.MethodOperation;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBundle;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.operation.SimpleOperation;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetryClient;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.PropertyKey;

public class AzureTelemeter {
    public static final String INFO_BUNDLE = "bundles.com.microsoft.azure.toolkit.info";
    public static final String SERVICE_NAME = "serviceName";
    public static final String OPERATION_NAME = "operationName";
    public static final String OP_ID = "op_id";
    public static final String OP_NAME = "op_name";
    public static final String OP_TYPE = "op_type";
    public static final String OP_PARENT_ID = "op_parentId";
    public static final String INFO_NAME = "info.name";
    public static final String INFO_SERVICE = "info.service";
    public static final String INFO_DETAILS = "info.details";
    public static final String ERROR_CODE = "error.error_code";
    public static final String ERROR_MSG = "error.error_msg";
    public static final String ERROR_ROOT_MSG = "error.root_error_message";
    public static final String ERROR_TYPE = "error.error_type";
    public static final String ERROR_CLASSNAME = "error.error_class_name";
    public static final String ERROR_ROOT_CLASSNAME = "error.root_error_class_name";
    public static final String ERROR_STACKTRACE = "error.error_stack_trace";
    @Nullable
    private static AzureTelemetryClient client = null;

    public static synchronized AzureTelemetryClient getClient() {
        if (client == null) {
            client = new AzureTelemetryClient();
        }
        return client;
    }

    public static void addCommonProperties(@Nonnull Map<String, String> commonProperties) {
        AzureTelemeter.getClient().addDefaultProperties(commonProperties);
    }

    public static void addCommonProperty(@Nonnull String key, @Nonnull String value) {
        AzureTelemeter.getClient().addDefaultProperty(key, value);
    }

    public static void setEventNamePrefix(@Nonnull String prefix) {
        AzureTelemeter.getClient().setEventNamePrefix(prefix);
    }

    public static void afterCreate(@Nonnull Operation op) {
        op.getContext().setTelemetryProperty("op_create_at", Instant.now().toString());
    }

    public static void beforeEnter(@Nonnull Operation op) {
        op.getContext().setTelemetryProperty("op_enter_at", Instant.now().toString());
    }

    public static void afterExit(@Nonnull Operation op) {
        op.getContext().setTelemetryProperty("op_exit_at", Instant.now().toString());
        AzureTelemeter.log(AzureTelemetry.Type.OP_END, AzureTelemeter.serialize(op));
    }

    public static void onError(@Nonnull Operation op, Throwable error) {
        op.getContext().setTelemetryProperty("op_exit_at", Instant.now().toString());
        AzureTelemeter.log(AzureTelemetry.Type.ERROR, AzureTelemeter.serialize(op), error);
    }

    public static void info(@Nonnull @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.info") @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.info") String key) {
        AzureTelemeter.log(AzureTelemetry.Type.INFO, (Map<String, String>)ImmutableMap.of((Object)INFO_NAME, (Object)StringUtils.substringAfter((String)key, (String)"."), (Object)INFO_SERVICE, (Object)StringUtils.substringBefore((String)key, (String)".")));
    }

    public static void info(@Nonnull @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.info") @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.info") String key, String details) {
        AzureTelemeter.log(AzureTelemetry.Type.INFO, (Map<String, String>)ImmutableMap.of((Object)INFO_NAME, (Object)StringUtils.substringAfter((String)key, (String)"."), (Object)INFO_SERVICE, (Object)StringUtils.substringBefore((String)key, (String)"."), (Object)INFO_DETAILS, (Object)details));
    }

    public static void info(@Nonnull @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.info") @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.info") String key, Map<String, String> details) {
        HashMap<String, String> map = new HashMap<String, String>(details);
        map.put(INFO_NAME, StringUtils.substringAfter((String)key, (String)"."));
        map.put(INFO_SERVICE, StringUtils.substringBefore((String)key, (String)"."));
        AzureTelemeter.log(AzureTelemetry.Type.INFO, map);
    }

    public static void log(AzureTelemetry.Type type, String opId) {
        AzureTelemeter.log(type, AzureTelemeter.serialize(new SimpleOperation(OperationBundle.description(opId, new Object[0]), () -> null, null)));
    }

    public static void log(AzureTelemetry.Type type, AzureString op) {
        AzureTelemeter.log(type, AzureTelemeter.serialize(new SimpleOperation(op, () -> null, null)));
    }

    public static void log(AzureTelemetry.Type type, String opId, Throwable e) {
        AzureTelemeter.log(type, AzureTelemeter.serialize(new SimpleOperation(OperationBundle.description(opId, new Object[0]), () -> null, null)), e);
    }

    public static void log(AzureTelemetry.Type type, AzureString op, Throwable e) {
        AzureTelemeter.log(type, AzureTelemeter.serialize(new SimpleOperation(op, () -> null, null)), e);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties, Throwable e) {
        if (Objects.nonNull(e)) {
            properties.putAll(AzureTelemeter.serialize(e));
        }
        AzureTelemeter.log(type, properties);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties) {
        if (!StringUtils.equals((CharSequence)properties.get(OP_NAME), (CharSequence)"<unknown>.<unknown>")) {
            String eventName = Optional.ofNullable(AzureTelemeter.getClient().getEventNamePrefix()).orElse("AzurePlugin") + "/" + type.getName();
            AzureTelemeter.getClient().trackEvent(eventName, properties, null);
        }
    }

    @Nonnull
    private static Map<String, String> serialize(@Nonnull Operation op) {
        OperationContext context = op.getContext();
        Map<String, String> actionProperties = AzureTelemeter.getActionProperties(op);
        Optional<Operation> parent = Optional.ofNullable(op.getEffectiveParent());
        HashMap<String, String> properties = new HashMap<String, String>();
        String name = op.getId().replaceAll("\\(.+\\)", "(***)");
        properties.put(OP_ID, op.getExecutionId());
        properties.put(OP_PARENT_ID, parent.map(Operation::getExecutionId).orElse("/"));
        properties.put(OP_NAME, name);
        properties.put(OP_TYPE, op.getType());
        properties.put(SERVICE_NAME, op.getServiceName());
        properties.put(OPERATION_NAME, op.getOperationName());
        properties.putAll(actionProperties);
        if (op instanceof MethodOperation) {
            properties.putAll(AzureTelemeter.getParameterProperties((MethodOperation)op));
        }
        properties.putAll(context.getTelemetryProperties());
        return properties;
    }

    private static Map<String, String> getParameterProperties(MethodOperation ref) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<Triple<String, Parameter, Object>> args = ref.getInvocation().getArgs();
        for (Triple<String, Parameter, Object> arg : args) {
            Parameter param = (Parameter)arg.getMiddle();
            Object value = arg.getRight();
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Property.class)).map(AzureTelemetry.Property::value).map(n -> "<param_name>".equals(n) ? param.getName() : n).ifPresent(name -> properties.put((String)name, Optional.ofNullable(value).map(Object::toString).orElse("")));
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Properties.class)).map(AzureTelemetry.Properties::value).map(AzureTelemeter::instantiate).map(converter -> converter.convert(value)).ifPresent(properties::putAll);
        }
        return properties;
    }

    @Nonnull
    private static Map<String, String> getActionProperties(@Nonnull Operation operation) {
        return Optional.ofNullable(operation.getActionParent()).map(Operation::getContext).map(OperationContext::getTelemetryProperties).orElse(new HashMap());
    }

    private static <U> U instantiate(Class<? extends U> clazz) {
        return clazz.newInstance();
    }

    @Nonnull
    private static HashMap<String, String> serialize(@Nonnull Throwable e) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ErrorType type = ErrorType.userError;
        properties.put(ERROR_CLASSNAME, e.getClass().getName());
        properties.put(ERROR_TYPE, type.name());
        properties.put(ERROR_MSG, e.getMessage());
        Optional.ofNullable(ExceptionUtils.getRootCause((Throwable)e)).ifPresent(root -> {
            properties.put(ERROR_ROOT_MSG, root.getMessage());
            properties.put(ERROR_ROOT_CLASSNAME, root.getClass().getName());
        });
        properties.put(ERROR_STACKTRACE, ExceptionUtils.getStackTrace((Throwable)e));
        return properties;
    }

    private static enum ErrorType {
        userError,
        systemError,
        serviceError,
        toolError,
        unclassifiedError;

    }
}

