/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class Azure {
    private final AzureConfiguration configuration = new AzureConfiguration();
    private static final ServiceLoader<AzureService> loader = ServiceLoader.load(AzureService.class);
    private static final Azure defaultInstance = new Azure();

    private Azure() {
    }

    public static <T extends AzureService> T az(Class<T> clazz) {
        return (T)StreamSupport.stream(loader.spliterator(), false).filter(clazz::isInstance).findAny().map(clazz::cast).orElseThrow(() -> new AzureToolkitRuntimeException(String.format("Azure service(%s) not supported", clazz.getSimpleName())));
    }

    public static Azure az() {
        return defaultInstance;
    }

    public AzureConfiguration config() {
        return this.configuration;
    }
}

