/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.microsoft.azure.toolkit.lib.common.cache.CacheEvict;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.ExpressionUtils;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CacheManager {
    private static final Logger log = Logger.getLogger(CacheManager.class.getName());
    private static final CacheLoader<String, Cache<Object, Object>> loader = new CacheLoader<String, Cache<Object, Object>>(){

        public Cache<Object, Object> load(@Nonnull String key) {
            return CacheBuilder.newBuilder().softValues().expireAfterAccess(4L, TimeUnit.HOURS).build();
        }
    };
    private static final LoadingCache<String, Cache<Object, Object>> caches = CacheBuilder.newBuilder().softValues().expireAfterAccess(4L, TimeUnit.HOURS).build(loader);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ CacheManager ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.cache.Cacheable * *..*.*(..))")
    public void cacheable() {
    }

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.cache.CacheEvict * *..*.*(..))")
    public void cacheEvict() {
    }

    @Around(value="cacheable()")
    public Object aroundCacheable(@Nonnull ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        MethodInvocation invocation = MethodInvocation.from((JoinPoint)point);
        Cacheable annotation = signature.getMethod().getAnnotation(Cacheable.class);
        String cacheName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.cacheName(), annotation.value()});
        String name = ExpressionUtils.render(cacheName, invocation);
        String key = ExpressionUtils.render(annotation.key(), invocation);
        if (Objects.isNull(name) || Objects.isNull(key)) {
            CacheManager.log.severe(String.format("invalid @Cacheable on method(%s)", signature.getName()));
            return point.proceed();
        }
        String condition = annotation.condition();
        boolean toUseCache = StringUtils.isBlank((CharSequence)condition) || ExpressionUtils.evaluate(condition, invocation, true);
        Cache cache = (Cache)CacheManager.caches.get((Object)name);
        if (toUseCache) {
            CacheManager.log.fine(String.format("loading data from cache[%s.%s] on method[%s]", name, key, signature.getName()));
            return this.readCache((Cache<Object, Object>)cache, key, point);
        }
        CacheManager.log.fine(String.format("skipping cache[%s.%s] on method[%s]", name, key, signature.getName()));
        Object result = point.proceed();
        if (Objects.nonNull(result)) {
            cache.put((Object)key, Optional.of(result));
        }
        return result;
    }

    @Around(value="cacheEvict()")
    public Object aroundCacheEvict(@Nonnull ProceedingJoinPoint point) throws Throwable {
        boolean toEvictCache;
        MethodSignature signature = (MethodSignature)point.getSignature();
        MethodInvocation invocation = MethodInvocation.from((JoinPoint)point);
        CacheEvict annotation = signature.getMethod().getAnnotation(CacheEvict.class);
        String cacheName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.cacheName(), annotation.value()});
        String name = ExpressionUtils.render(cacheName, invocation);
        String key = ExpressionUtils.render(annotation.key(), invocation);
        String condition = annotation.condition();
        boolean bl = toEvictCache = StringUtils.isBlank((CharSequence)condition) || ExpressionUtils.evaluate(condition, invocation, true);
        if (toEvictCache) {
            CacheManager.log.fine(String.format("evict cache[%s.%s] on method[%s]", name, key, signature.getName()));
            this.invalidateCache(name, key);
        }
        return point.proceed();
    }

    private void invalidateCache(@Nullable String name, @Nullable String key) throws ExecutionException {
        if (StringUtils.isBlank((CharSequence)name)) {
            log.warning("cache name is not specified when invalidating cache");
        } else if (StringUtils.equals((CharSequence)"<ALL>", (CharSequence)name)) {
            log.fine("invalidate all caches");
            caches.invalidateAll();
        } else if (StringUtils.isBlank((CharSequence)key)) {
            log.warning(String.format("key is not specified when invalidating cache[%s]", name));
        } else if (StringUtils.equals((CharSequence)"<ALL>", (CharSequence)key)) {
            log.fine(String.format("invalidate all entries in cache[%s]", name));
            caches.invalidate((Object)name);
        } else {
            log.fine(String.format("invalidate cache entry[%s.%s]", name, key));
            ((Cache)caches.get((Object)name)).invalidate((Object)key);
        }
    }

    private Object readCache(Cache<Object, Object> cache, String key, ProceedingJoinPoint point) throws Throwable {
        Optional result = (Optional)cache.get((Object)key, () -> {
            try {
                log.fine(String.format("cache[%s] miss on method[%s]", key, point.getSignature().getName()));
                return Optional.ofNullable(point.proceed());
            }
            catch (Throwable throwable) {
                log.log(Level.FINE, String.format("error occurs on loading data into cache[%s] on method[%s]", key, point.getSignature().getName()), throwable);
                return Optional.of(throwable);
            }
        });
        if (result.isPresent() && result.get() instanceof Throwable) {
            cache.invalidate((Object)key);
            throw (Throwable)result.get();
        }
        return result.orElse(null);
    }

    static {
        try {
            CacheManager.ajc$perSingletonInstance = new CacheManager();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static CacheManager aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.cache.CacheManager", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

