/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.exception;

import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AzureExceptionHandler {
    private static final Logger log = Logger.getLogger(AzureExceptionHandler.class.getName());
    private static AzureExceptionHandler handler;

    public static synchronized void register(AzureExceptionHandler handler) {
        if (AzureExceptionHandler.handler == null) {
            AzureExceptionHandler.handler = handler;
        }
    }

    public static AzureExceptionHandler getInstance() {
        return handler;
    }

    public static void onUncaughtException(Throwable e) {
        AzureExceptionHandler.getInstance().handleException(e, new AzureExceptionAction[0]);
    }

    public static void notify(Throwable e, AzureExceptionAction ... actions) {
        AzureExceptionHandler.getInstance().handleException(e, actions);
    }

    public static void notify(Throwable e, boolean background, AzureExceptionAction ... actions) {
        AzureExceptionHandler.getInstance().handleException(e, background, actions);
    }

    public static void onRxException(Throwable e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (rootCause instanceof InterruptedIOException || rootCause instanceof InterruptedException) {
            return;
        }
        AzureExceptionHandler.getInstance().handleException(e, new AzureExceptionAction[0]);
    }

    public void handleException(Throwable throwable, AzureExceptionAction ... action) {
        log.log(Level.WARNING, "caught an error in AzureExceptionHandler", throwable);
        Boolean backgrounded = Optional.ofNullable(AzureTaskContext.current().getTask()).map(AzureTask::getBackgrounded).orElse(null);
        if (Objects.nonNull(backgrounded)) {
            this.onHandleException(throwable, backgrounded, action);
            return;
        }
        this.onHandleException(throwable, action);
    }

    public void handleException(Throwable throwable, boolean isBackGround, AzureExceptionAction ... action) {
        log.log(Level.WARNING, "caught an error in AzureExceptionHandler", throwable);
        this.onHandleException(throwable, isBackGround, action);
    }

    protected abstract void onHandleException(Throwable var1, @Nullable AzureExceptionAction[] var2);

    protected abstract void onHandleException(Throwable var1, boolean var2, @Nullable AzureExceptionAction[] var3);

    public static interface AzureExceptionAction {
        public String name();

        public void actionPerformed(Throwable var1);

        public static AzureExceptionAction simple(final String name, final Consumer<? super Throwable> consumer) {
            return new AzureExceptionAction(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public void actionPerformed(Throwable throwable) {
                    consumer.accept(throwable);
                }
            };
        }
    }
}

