/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.DataStore;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskContext;
import javax.annotation.Nullable;

public interface IAzureOperation
extends DataStore {
    public static final String UNKNOWN_NAME = "<unknown>.<unknown>";

    public String getId();

    public String getName();

    public String getType();

    public Object getTitle();

    public void setParent(IAzureOperation var1);

    @Nullable
    public IAzureOperation getParent();

    default public IAzureOperation getEffectiveParent() {
        IAzureOperation parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.getName().equals(UNKNOWN_NAME)) {
            return parent;
        }
        return parent.getEffectiveParent();
    }

    default public IAzureOperation getActionParent() {
        IAzureOperation parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getType().equals(AzureOperation.Type.ACTION.name())) {
            return parent;
        }
        return parent.getActionParent();
    }

    @Nullable
    public static IAzureOperation current() {
        return AzureTaskContext.current().currentOperation();
    }
}

