/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperationTitle;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.Optional;
import java.util.function.Supplier;

public class AzureTask<T>
implements IAzureOperation {
    private final Modality modality;
    private final Supplier<T> supplier;
    private final Object project;
    private final boolean cancellable;
    private final IAzureOperationTitle title;
    private IAzureOperation parent;
    private boolean backgroundable = true;
    private Boolean backgrounded = null;

    public AzureTask(Runnable runnable) {
        this(runnable, Modality.DEFAULT);
    }

    public AzureTask(String title, Runnable runnable) {
        this(title, runnable, Modality.DEFAULT);
    }

    public AzureTask(IAzureOperationTitle title, Runnable runnable) {
        this(title, runnable, Modality.DEFAULT);
    }

    public AzureTask(Supplier<T> supplier) {
        this(supplier, Modality.DEFAULT);
    }

    public AzureTask(String title, Supplier<T> supplier) {
        this(null, title, false, supplier, Modality.DEFAULT);
    }

    public AzureTask(IAzureOperationTitle title, Supplier<T> supplier) {
        this(null, title, false, supplier, Modality.DEFAULT);
    }

    public AzureTask(Runnable runnable, Modality modality) {
        this(null, (String)null, false, runnable, modality);
    }

    public AzureTask(String title, Runnable runnable, Modality modality) {
        this(null, title, false, runnable, modality);
    }

    public AzureTask(IAzureOperationTitle title, Runnable runnable, Modality modality) {
        this(null, title, false, runnable, modality);
    }

    public AzureTask(Supplier<T> supplier, Modality modality) {
        this(null, (String)null, false, supplier, modality);
    }

    public AzureTask(String title, Supplier<T> supplier, Modality modality) {
        this(null, title, false, supplier, modality);
    }

    public AzureTask(IAzureOperationTitle title, Supplier<T> supplier, Modality modality) {
        this(null, title, false, supplier, modality);
    }

    public AzureTask(Object project, String title, boolean cancellable, Runnable runnable) {
        this(project, title, cancellable, runnable, Modality.DEFAULT);
    }

    public AzureTask(Object project, IAzureOperationTitle title, boolean cancellable, Runnable runnable) {
        this(project, title, cancellable, runnable, Modality.DEFAULT);
    }

    public AzureTask(Object project, String title, boolean cancellable, Supplier<T> supplier) {
        this(project, title, cancellable, supplier, Modality.DEFAULT);
    }

    public AzureTask(Object project, IAzureOperationTitle title, boolean cancellable, Supplier<T> supplier) {
        this(project, title, cancellable, supplier, Modality.DEFAULT);
    }

    public AzureTask(Object project, String title, boolean cancellable, Runnable runnable, Modality modality) {
        this(project, (IAzureOperationTitle)new IAzureOperationTitle.Simple(title), cancellable, runnable, modality);
    }

    public AzureTask(Object project, IAzureOperationTitle title, boolean cancellable, Runnable runnable, Modality modality) {
        this(project, title, cancellable, () -> {
            runnable.run();
            return null;
        }, modality);
    }

    public AzureTask(Object project, String title, boolean cancellable, Supplier<T> supplier, Modality modality) {
        this(project, (IAzureOperationTitle)new IAzureOperationTitle.Simple(title), cancellable, supplier, modality);
    }

    public AzureTask(Object project, IAzureOperationTitle title, boolean cancellable, Supplier<T> supplier, Modality modality) {
        this.project = project;
        this.title = title;
        this.cancellable = cancellable;
        this.supplier = supplier;
        this.modality = modality;
    }

    @Override
    public String getId() {
        return "&" + Utils.getId(this);
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.getTitle()).map(IAzureOperationTitle::getName).orElse("<unknown>.<unknown>");
    }

    @Override
    public String getType() {
        return "ASYNC";
    }

    public String toString() {
        return String.format("{name:'%s'}", this.getName());
    }

    public Modality getModality() {
        return this.modality;
    }

    public Supplier<T> getSupplier() {
        return this.supplier;
    }

    public Object getProject() {
        return this.project;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    public IAzureOperationTitle getTitle() {
        return this.title;
    }

    @Override
    public IAzureOperation getParent() {
        return this.parent;
    }

    public boolean isBackgroundable() {
        return this.backgroundable;
    }

    public Boolean getBackgrounded() {
        return this.backgrounded;
    }

    @Override
    public void setParent(IAzureOperation parent) {
        this.parent = parent;
    }

    public void setBackgroundable(boolean backgroundable) {
        this.backgroundable = backgroundable;
    }

    public void setBackgrounded(Boolean backgrounded) {
        this.backgrounded = backgrounded;
    }

    public static enum Modality {
        DEFAULT,
        ANY,
        NONE;

    }
}

