/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationRef;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureTelemeter {
    private static final String SERVICE_NAME = "serviceName";
    private static final String OPERATION_NAME = "operationName";
    private static final String OP_ID = "op_id";
    private static final String OP_NAME = "op_name";
    private static final String OP_TYPE = "op_type";
    private static final String OP_PARENT_ID = "op_parentId";
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_MSG = "message";
    private static final String ERROR_TYPE = "errorType";
    private static final String ERROR_CLASSNAME = "errorClassName";
    private static final String ERROR_STACKTRACE = "errorStackTrace";
    private static String eventNamePrefix;
    private static Map<String, String> commonProperties;
    private static TelemetryClient client;

    public static void afterCreate(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = op.get(AzureTelemetry.Context.class, new AzureTelemetry.Context());
        context.setCreateAt(Instant.now());
    }

    public static void beforeEnter(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = op.get(AzureTelemetry.Context.class, new AzureTelemetry.Context());
        context.setEnterAt(Instant.now());
    }

    public static void afterExit(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = op.get(AzureTelemetry.Context.class, new AzureTelemetry.Context());
        context.setExitAt(Instant.now());
        AzureTelemeter.log(AzureTelemetry.Type.INFO, AzureTelemeter.serialize(op));
    }

    public static void onError(@Nonnull IAzureOperation op, Throwable error) {
        AzureTelemetry.Context context = op.get(AzureTelemetry.Context.class, new AzureTelemetry.Context());
        context.setExitAt(Instant.now());
        AzureTelemeter.log(AzureTelemetry.Type.ERROR, AzureTelemeter.serialize(op), error);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties, Throwable e) {
        if (Objects.nonNull(e)) {
            properties.putAll(AzureTelemeter.serialize(e));
        }
        AzureTelemeter.log(type, properties);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties) {
        if (client != null) {
            properties.putAll(AzureTelemeter.getCommonProperties());
            String eventName = AzureTelemeter.getEventNamePrefix() + "/" + type.name();
            client.trackEvent(eventName, properties, null);
            client.flush();
        }
    }

    @Nonnull
    private static Map<String, String> serialize(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context operationContext = op.get(AzureTelemetry.Context.class, new AzureTelemetry.Context());
        AzureTelemetry.Context actionContext = Optional.ofNullable(op.getActionParent()).map(o -> o.get(AzureTelemetry.Context.class)).orElse(new AzureTelemetry.Context());
        Optional<IAzureOperation> parent = Optional.ofNullable(op.getParent());
        HashMap<String, String> properties = new HashMap<String, String>();
        String name = op.getName().replaceAll("\\(.+\\)", "(***)");
        String[] parts = name.split("\\.");
        String[] compositeServiceName = parts[0].split("\\|");
        String mainServiceName = compositeServiceName[0];
        String operationName = compositeServiceName.length > 1 ? parts[1] + "_" + compositeServiceName[1] : parts[1];
        properties.put(SERVICE_NAME, mainServiceName);
        properties.put(OPERATION_NAME, operationName);
        properties.put(OP_ID, op.getId());
        properties.put(OP_PARENT_ID, parent.map(IAzureOperation::getId).orElse("/"));
        properties.put(OP_NAME, name);
        properties.put(OP_TYPE, op.getType());
        properties.putAll(actionContext.getProperties());
        if (op instanceof AzureOperationRef) {
            properties.putAll(AzureTelemeter.getParameterProperties((AzureOperationRef)op));
        }
        properties.putAll(operationContext.getProperties());
        return properties;
    }

    private static Map<String, String> getParameterProperties(AzureOperationRef ref) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Object[] paramValues = ref.getParamValues();
        Parameter[] parameters = ref.getMethod().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            Object value = paramValues[i];
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Property.class)).map(AzureTelemetry.Property::value).map(n -> "<param_name>".equals(n) ? param.getName() : n).ifPresent(name -> properties.put((String)name, Optional.ofNullable(value).map(Object::toString).orElse("")));
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Properties.class)).map(AzureTelemetry.Properties::value).map(AzureTelemeter::instantiate).map(converter -> converter.convert(value)).ifPresent(properties::putAll);
        }
        return properties;
    }

    private static <U> U instantiate(Class<? extends U> clazz) {
        return clazz.newInstance();
    }

    @Nonnull
    private static HashMap<String, String> serialize(@Nonnull Throwable e) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ErrorType type = ErrorType.userError;
        properties.put(ERROR_CLASSNAME, e.getClass().getName());
        properties.put(ERROR_TYPE, type.name());
        properties.put(ERROR_MSG, e.getMessage());
        properties.put(ERROR_STACKTRACE, ExceptionUtils.getStackTrace((Throwable)e));
        return properties;
    }

    public static String getEventNamePrefix() {
        return eventNamePrefix;
    }

    public static void setEventNamePrefix(String eventNamePrefix) {
        AzureTelemeter.eventNamePrefix = eventNamePrefix;
    }

    public static Map<String, String> getCommonProperties() {
        return commonProperties;
    }

    public static void setCommonProperties(Map<String, String> commonProperties) {
        AzureTelemeter.commonProperties = commonProperties;
    }

    public static TelemetryClient getClient() {
        return client;
    }

    public static void setClient(TelemetryClient client) {
        AzureTelemeter.client = client;
    }

    private static enum ErrorType {
        userError,
        systemError,
        serviceError,
        toolError,
        unclassifiedError;

    }
}

