/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SubscriptionScoped<T extends AzureService> {
    @Nonnull
    private final Function<List<Subscription>, T> creator;
    @Nullable
    private final List<Subscription> subscriptions;

    protected SubscriptionScoped(@Nonnull Function<List<Subscription>, T> creator) {
        this.creator = creator;
        this.subscriptions = null;
    }

    public List<Subscription> getSubscriptions() {
        if (Objects.isNull(this.subscriptions)) {
            return Azure.az(IAzureAccount.class).account().getSelectedSubscriptions();
        }
        return this.subscriptions;
    }

    public T subscriptions(@Nonnull List<Subscription> subscriptions) {
        assert (CollectionUtils.isNotEmpty(subscriptions)) : "subscriptions can not be empty!";
        return (T)((AzureService)this.creator.apply(subscriptions));
    }

    public T subscription(@Nonnull Subscription subscription) {
        return this.subscriptions(Collections.singletonList(subscription));
    }

    public T subscription(@Nonnull String subscriptionId) {
        return this.subscriptions(subscriptionId);
    }

    public T subscriptions(String ... subscriptions) {
        assert (ArrayUtils.isNotEmpty((Object[])subscriptions)) : "subscriptions can not be empty!";
        List<Subscription> subscriptionList = Azure.az(IAzureAccount.class).account().getSubscriptions().stream().filter(subscription -> ArrayUtils.contains((Object[])subscriptions, (Object)subscription.getId())).collect(Collectors.toList());
        return this.subscriptions(subscriptionList);
    }

    public Subscription getDefaultSubscription() {
        return Optional.ofNullable(CollectionUtils.size(this.getSubscriptions()) == 1 ? this.getSubscriptions().get(0) : null).orElseThrow(() -> new AzureToolkitRuntimeException("Multiple subscriptions found in current account, please set the subscription id"));
    }

    public SubscriptionScoped(@Nonnull Function<List<Subscription>, T> creator, @Nullable List<Subscription> subscriptions) {
        if (creator == null) {
            throw new NullPointerException("creator is marked non-null but is null");
        }
        this.creator = creator;
        this.subscriptions = subscriptions;
    }
}

