/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.cache;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.common.cache.Preload;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class Preloader {
    private static final Logger log = Logger.getLogger(Preloader.class.getName());
    private static final String INVALID_PRELOAD_METHOD = "@Preload annotated method(%s.%s) should have (no args or only varargs) and must be (static or in a singleton class)";

    public static Collection<Method> load() {
        log.fine("Start Scanning for @Preload");
        Set<Method> methods = Preloader.getPreloadingMethods();
        log.fine(String.format("Found %d @Preload annotated methods.", methods.size()));
        log.fine("End Scanning for @Preload");
        log.fine("Start Preloading");
        methods.parallelStream().forEach(m -> {
            Object instance = null;
            if ((m.getParameterCount() == 0 || m.isVarArgs()) && (Modifier.isStatic(m.getModifiers()) || Objects.nonNull(instance = Preloader.getSingleton(m)))) {
                log.fine(String.format("preloading [%s]", m.getName()));
                Preloader.invoke(m, instance);
                log.fine(String.format("preloaded [%s]", m.getName()));
            } else {
                log.warning(String.format(INVALID_PRELOAD_METHOD, m.getDeclaringClass().getSimpleName(), m.getName()));
            }
        });
        log.fine("End Preloading");
        return methods;
    }

    private static void invoke(Method m, Object instance) {
        try {
            if (m.isVarArgs()) {
                Class<?> varargType = m.getParameterTypes()[0].getComponentType();
                if (varargType.equals(Boolean.class)) {
                    m.invoke(instance, new Object[]{new Boolean[]{true}});
                } else if (varargType.equals(Boolean.TYPE)) {
                    m.invoke(instance, new Object[]{new boolean[]{true}});
                } else {
                    m.invoke(instance, Array.newInstance(varargType, 0));
                }
            } else {
                m.invoke(instance, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Nullable
    private static Object getSingleton(Method m) {
        Class<?> clazz = m.getDeclaringClass();
        try {
            if (AzureService.class.isAssignableFrom(clazz)) {
                return Azure.az(clazz);
            }
            String methodName = "getInstance";
            Method getInstance = clazz.getDeclaredMethod("getInstance", new Class[0]);
            if (Modifier.isStatic(getInstance.getModifiers()) && getInstance.getParameterCount() == 0) {
                getInstance.setAccessible(true);
                return getInstance.invoke(null, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Set<Method> getPreloadingMethods() {
        ConfigurationBuilder configuration = new ConfigurationBuilder().forPackages(new String[]{"com.microsoft.azure.toolkit", "com.microsoft.azuretools"}).setScanners(new Scanner[]{new MethodAnnotationsScanner()});
        Reflections reflections = new Reflections((Configuration)configuration);
        return reflections.getMethodsAnnotatedWith(Preload.class);
    }
}

