/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.event;

import com.microsoft.azure.toolkit.lib.common.event.AzureEvent;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationRef;
import javax.annotation.Nonnull;

public class AzureOperationEvent<T extends Source<T>>
implements AzureEvent<T> {
    private final T source;
    private final AzureOperationRef operation;
    private final Stage stage;

    @Override
    @Nonnull
    public String getType() {
        return this.operation.getName();
    }

    @Override
    public T getPayload() {
        return this.source;
    }

    public T getSource() {
        return this.source;
    }

    public AzureOperationRef getOperation() {
        return this.operation;
    }

    public Stage getStage() {
        return this.stage;
    }

    public AzureOperationEvent(T source, AzureOperationRef operation, Stage stage) {
        this.source = source;
        this.operation = operation;
        this.stage = stage;
    }

    public static enum Stage {
        BEFORE,
        AFTER,
        ERROR;

    }

    public static interface Source<T> {
        @Nonnull
        default public Source<T> getEventSource() {
            return this;
        }
    }
}

