/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.exception;

import com.google.common.base.Throwables;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RestExceptionHandlerInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            Request request = chain.request();
            return chain.proceed(request);
        }
        catch (Exception ex) {
            List exceptions = Throwables.getCausalChain((Throwable)ex);
            if (exceptions.stream().anyMatch(e -> e instanceof UnknownHostException)) {
                throw new AzureToolkitRuntimeException("Unknown host! You network condition maybe unstable, please try later.");
            }
            if (exceptions.stream().anyMatch(e -> e instanceof AuthenticationException)) {
                throw new AzureToolkitRuntimeException("Invalid authentication! You may sign in again or run \"az login\" if using Azure CLI credential");
            }
            throw ex;
        }
    }
}

