/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AzureMessage
implements IAzureMessage {
    @Nonnull
    public static Context getContext() {
        return AzureMessage.getContext(IAzureOperation.current());
    }

    @Nonnull
    public static Context getActionContext() {
        IAzureOperation operation = IAzureOperation.current();
        return Optional.ofNullable(operation).map(IAzureOperation::getActionParent).map(AzureMessage::getContext).orElse(new Context(operation));
    }

    @Nonnull
    public static Context getContext(@Nullable IAzureOperation operation) {
        return Optional.ofNullable(operation).map(o -> o.get(Context.class, new Context(operation))).orElse(new Context(operation));
    }

    public static class Context
    implements IAzureOperation.IContext {
        @Nullable
        private final IAzureOperation operation;
        private IAzureMessager messager = null;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public void setProperty(@Nonnull String key, Object val) {
            this.properties.put(key, val);
        }

        public Object getProperty(@Nonnull String key) {
            return this.properties.get(key);
        }

        public void setMessager(@Nonnull IAzureMessager messager) {
            this.messager = messager;
        }

        @Nonnull
        public IAzureMessager getMessager() {
            if (Objects.nonNull(this.messager)) {
                return this.messager;
            }
            return this.getMessager(Optional.ofNullable(this.operation).map(IAzureOperation::getParent).orElse(null));
        }

        @Nonnull
        public IAzureMessager getActionMessager() {
            return this.getMessager(Optional.ofNullable(this.operation).map(IAzureOperation::getActionParent).orElse(null));
        }

        @Nonnull
        private IAzureMessager getMessager(@Nullable IAzureOperation op) {
            return Optional.ofNullable(op).map(AzureMessage::getContext).map(Context::getMessager).orElse(AzureMessager.getDefaultMessager());
        }

        public Context(@Nullable IAzureOperation operation) {
            this.operation = operation;
        }
    }
}

