/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.SimpleMessage;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface IAzureMessager {
    public static final String DEFAULT_TITLE = "Azure";

    default public void success(@Nonnull String message, String title, IAzureMessage.Action ... actions) {
        this.show(new SimpleMessage(IAzureMessage.Type.SUCCESS, message).setActions(actions).setTitle(title));
    }

    default public void info(@Nonnull String message, String title, IAzureMessage.Action ... actions) {
        this.show(new SimpleMessage(IAzureMessage.Type.INFO, message).setActions(actions).setTitle(title));
    }

    default public void warning(@Nonnull String message, String title, IAzureMessage.Action ... actions) {
        this.show(new SimpleMessage(IAzureMessage.Type.WARNING, message).setActions(actions).setTitle(title));
    }

    default public void error(@Nonnull String message, String title, IAzureMessage.Action ... actions) {
        this.show(new SimpleMessage(IAzureMessage.Type.ERROR, message).setActions(actions).setTitle(title));
    }

    default public void error(@Nonnull Throwable throwable, String title, IAzureMessage.Action ... actions) {
        String message = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getSimpleName());
        this.show(new SimpleMessage(IAzureMessage.Type.ERROR, message).setPayload(throwable).setActions(actions).setTitle(title));
    }

    default public boolean confirm(@Nonnull String message, String title) {
        return this.show(new SimpleMessage(IAzureMessage.Type.CONFIRM, message).setTitle(title));
    }

    default public void alert(@Nonnull String message, String title) {
        this.show(new SimpleMessage(IAzureMessage.Type.ALERT, message).setTitle(title));
    }

    default public void success(@Nonnull String message, String title) {
        this.success(message, title, new IAzureMessage.Action[0]);
    }

    default public void info(@Nonnull String message, String title) {
        this.info(message, title, new IAzureMessage.Action[0]);
    }

    default public void warning(@Nonnull String message, String title) {
        this.warning(message, title, new IAzureMessage.Action[0]);
    }

    default public void error(@Nonnull String message, String title) {
        this.error(message, title, new IAzureMessage.Action[0]);
    }

    default public void error(@Nonnull Throwable throwable, String title) {
        this.error(throwable, title, new IAzureMessage.Action[0]);
    }

    default public boolean confirm(@Nonnull String message) {
        return this.confirm(message, DEFAULT_TITLE);
    }

    default public void alert(@Nonnull String message) {
        this.alert(message, DEFAULT_TITLE);
    }

    default public void success(@Nonnull String message) {
        this.success(message, DEFAULT_TITLE);
    }

    default public void info(@Nonnull String message) {
        this.info(message, DEFAULT_TITLE);
    }

    default public void warning(@Nonnull String message) {
        this.warning(message, DEFAULT_TITLE);
    }

    default public void error(@Nonnull String message) {
        this.error(message, DEFAULT_TITLE);
    }

    default public void error(@Nonnull Throwable throwable) {
        this.error(throwable, DEFAULT_TITLE);
    }

    default public String value(String val) {
        return val;
    }

    public boolean show(IAzureMessage var1);
}

