/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperationTitle;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AzureOperationBundle {
    private static Provider provider;

    public static synchronized void register(Provider provider) {
        if (AzureOperationBundle.provider == null) {
            AzureOperationBundle.provider = provider;
        }
    }

    public static IAzureOperationTitle title(@NotNull String name, Object ... params) {
        return MessageBundleBasedOperationTitle.builder().name(name).params(params).build();
    }

    public static interface Provider {
        public String getMessage(@NotNull String var1, Object ... var2);
    }

    public static class MessageBundleBasedOperationTitle
    implements IAzureOperationTitle {
        private final String name;
        private final Object[] params;
        private String title;

        public String toString() {
            if (Objects.isNull(this.title)) {
                this.title = provider.getMessage(this.name, this.params);
            }
            return this.title;
        }

        MessageBundleBasedOperationTitle(String name, Object[] params, String title) {
            this.name = name;
            this.params = params;
            this.title = title;
        }

        public static MessageBundleBasedOperationTitleBuilder builder() {
            return new MessageBundleBasedOperationTitleBuilder();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object[] getParams() {
            return this.params;
        }

        public String getTitle() {
            return this.title;
        }

        public static class MessageBundleBasedOperationTitleBuilder {
            private String name;
            private Object[] params;
            private String title;

            MessageBundleBasedOperationTitleBuilder() {
            }

            public MessageBundleBasedOperationTitleBuilder name(String name) {
                this.name = name;
                return this;
            }

            public MessageBundleBasedOperationTitleBuilder params(Object[] params) {
                this.params = params;
                return this;
            }

            public MessageBundleBasedOperationTitleBuilder title(String title) {
                this.title = title;
                return this;
            }

            public MessageBundleBasedOperationTitle build() {
                return new MessageBundleBasedOperationTitle(this.name, this.params, this.title);
            }

            public String toString() {
                return "AzureOperationBundle.MessageBundleBasedOperationTitle.MessageBundleBasedOperationTitleBuilder(name=" + this.name + ", params=" + Arrays.deepToString(this.params) + ", title=" + this.title + ")";
            }
        }
    }
}

