/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationRef;
import com.microsoft.azure.toolkit.lib.common.operation.IAzureOperation;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetry;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AzureTelemeter {
    private static final String SERVICE_NAME = "serviceName";
    private static final String OPERATION_NAME = "operationName";
    private static final String OP_ID = "op_id";
    private static final String OP_NAME = "op_name";
    private static final String OP_TYPE = "op_type";
    private static final String OP_PARENT_ID = "op_parentId";
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_MSG = "message";
    private static final String ERROR_TYPE = "errorType";
    private static final String ERROR_CLASSNAME = "errorClassName";
    private static final String ERROR_STACKTRACE = "errorStackTrace";
    @Nullable
    private static String eventNamePrefix;
    @Nullable
    private static Map<String, String> commonProperties;
    @Nullable
    private static TelemetryClient client;

    public static void afterCreate(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = AzureTelemetry.getContext(op);
        context.setCreateAt(Instant.now());
    }

    public static void beforeEnter(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = AzureTelemetry.getContext(op);
        context.setEnterAt(Instant.now());
    }

    public static void afterExit(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = AzureTelemetry.getContext(op);
        context.setExitAt(Instant.now());
        AzureTelemeter.log(AzureTelemetry.Type.INFO, AzureTelemeter.serialize(op));
    }

    public static void onError(@Nonnull IAzureOperation op, Throwable error) {
        AzureTelemetry.Context context = AzureTelemetry.getContext(op);
        context.setExitAt(Instant.now());
        AzureTelemeter.log(AzureTelemetry.Type.ERROR, AzureTelemeter.serialize(op), error);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties, Throwable e) {
        if (Objects.nonNull(e)) {
            properties.putAll(AzureTelemeter.serialize(e));
        }
        AzureTelemeter.log(type, properties);
    }

    public static void log(AzureTelemetry.Type type, Map<String, String> properties) {
        if (client != null) {
            properties.putAll(Optional.ofNullable(AzureTelemeter.getCommonProperties()).orElse(new HashMap()));
            String eventName = Optional.ofNullable(AzureTelemeter.getEventNamePrefix()).orElse("AzurePlugin") + "/" + type.name();
            client.trackEvent(eventName, properties, null);
            client.flush();
        }
    }

    @Nonnull
    private static Map<String, String> serialize(@Nonnull IAzureOperation op) {
        AzureTelemetry.Context context = AzureTelemetry.getContext(op);
        Map<String, String> actionProperties = AzureTelemeter.getActionProperties(context.getOperation());
        Optional<IAzureOperation> parent = Optional.ofNullable(op.getParent());
        HashMap<String, String> properties = new HashMap<String, String>();
        String name = op.getName().replaceAll("\\(.+\\)", "(***)");
        String[] parts = name.split("\\.");
        String[] compositeServiceName = parts[0].split("\\|");
        String mainServiceName = compositeServiceName[0];
        String operationName = compositeServiceName.length > 1 ? parts[1] + "_" + compositeServiceName[1] : parts[1];
        properties.put(SERVICE_NAME, mainServiceName);
        properties.put(OPERATION_NAME, operationName);
        properties.put(OP_ID, op.getId());
        properties.put(OP_PARENT_ID, parent.map(IAzureOperation::getId).orElse("/"));
        properties.put(OP_NAME, name);
        properties.put(OP_TYPE, op.getType());
        properties.putAll(actionProperties);
        if (op instanceof AzureOperationRef) {
            properties.putAll(AzureTelemeter.getParameterProperties((AzureOperationRef)op));
        }
        properties.putAll(context.getProperties());
        return properties;
    }

    private static Map<String, String> getParameterProperties(AzureOperationRef ref) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Object[] paramValues = ref.getParamValues();
        Parameter[] parameters = ref.getMethod().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            Object value = paramValues[i];
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Property.class)).map(AzureTelemetry.Property::value).map(n -> "<param_name>".equals(n) ? param.getName() : n).ifPresent(name -> properties.put((String)name, Optional.ofNullable(value).map(Object::toString).orElse("")));
            Optional.ofNullable(param.getAnnotation(AzureTelemetry.Properties.class)).map(AzureTelemetry.Properties::value).map(AzureTelemeter::instantiate).map(converter -> converter.convert(value)).ifPresent(properties::putAll);
        }
        return properties;
    }

    @Nonnull
    private static Map<String, String> getActionProperties(IAzureOperation operation) {
        return Optional.ofNullable(operation).map(IAzureOperation::getActionParent).map(o -> o.get(AzureTelemetry.Context.class, new AzureTelemetry.Context((IAzureOperation)o))).map(AzureTelemetry.Context::getProperties).orElse(new HashMap());
    }

    private static <U> U instantiate(Class<? extends U> clazz) {
        return clazz.newInstance();
    }

    @Nonnull
    private static HashMap<String, String> serialize(@Nonnull Throwable e) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ErrorType type = ErrorType.userError;
        properties.put(ERROR_CLASSNAME, e.getClass().getName());
        properties.put(ERROR_TYPE, type.name());
        properties.put(ERROR_MSG, e.getMessage());
        properties.put(ERROR_STACKTRACE, ExceptionUtils.getStackTrace((Throwable)e));
        return properties;
    }

    @Nullable
    public static String getEventNamePrefix() {
        return eventNamePrefix;
    }

    public static void setEventNamePrefix(@Nullable String eventNamePrefix) {
        AzureTelemeter.eventNamePrefix = eventNamePrefix;
    }

    @Nullable
    public static Map<String, String> getCommonProperties() {
        return commonProperties;
    }

    public static void setCommonProperties(@Nullable Map<String, String> commonProperties) {
        AzureTelemeter.commonProperties = commonProperties;
    }

    @Nullable
    public static TelemetryClient getClient() {
        return client;
    }

    public static void setClient(@Nullable TelemetryClient client) {
        AzureTelemeter.client = client;
    }

    private static enum ErrorType {
        userError,
        systemError,
        serviceError,
        toolError,
        unclassifiedError;

    }
}

