/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandUtils {
    private static final Logger log = LoggerFactory.getLogger(CommandUtils.class);
    private static final String WINDOWS_STARTER = "cmd.exe";
    private static final String LINUX_MAC_STARTER = "/bin/sh";
    private static final String WINDOWS_SWITCHER = "/c";
    private static final String LINUX_MAC_SWITCHER = "-c";
    private static final String DEFAULT_WINDOWS_SYSTEM_ROOT = System.getenv("SystemRoot");
    private static final String DEFAULT_MAC_LINUX_PATH = "/bin/";

    public static String exec(String commandWithArgs) throws IOException {
        String starter = CommandUtils.isWindows() ? WINDOWS_STARTER : LINUX_MAC_STARTER;
        String switcher = CommandUtils.isWindows() ? WINDOWS_SWITCHER : LINUX_MAC_SWITCHER;
        String workingDirectory = CommandUtils.getSafeWorkingDirectory();
        if (StringUtils.isEmpty((CharSequence)workingDirectory)) {
            IllegalStateException exception = new IllegalStateException("A Safe Working directory could not be found to execute command from.");
            log.error(CommandUtils.class.getName(), (Object)"exec", (Object)exception);
            throw exception;
        }
        String commandWithPath = CommandUtils.isWindows() ? commandWithArgs : String.format("export PATH=$PATH:/usr/local/bin ; %s", commandWithArgs);
        return CommandUtils.executeCommandAndGetOutput(starter, switcher, commandWithPath, new File(workingDirectory));
    }

    private static String executeCommandAndGetOutput(String starter, String switcher, String commandWithArgs, File directory) throws IOException {
        CommandLine commandLine = new CommandLine(starter);
        commandLine.addArgument(switcher, false);
        commandLine.addArgument(commandWithArgs, false);
        return CommandUtils.executeCommandAndGetOutput(commandLine, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeCommandAndGetOutput(CommandLine commandLine, File directory) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(directory);
        executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        executor.setExitValues(new int[]{0});
        try {
            executor.execute(commandLine);
            if (err.size() > 0) {
                log.warn(StringUtils.trim((String)err.toString()));
            }
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
            err.close();
        }
    }

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    private static String getSafeWorkingDirectory() {
        if (CommandUtils.isWindows()) {
            if (StringUtils.isEmpty((CharSequence)DEFAULT_WINDOWS_SYSTEM_ROOT)) {
                return null;
            }
            return DEFAULT_WINDOWS_SYSTEM_ROOT + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }
}

