/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.google.common.base.Preconditions;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.CommandExecuteException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private static final String POM = "pom";
    private static final String JAR = "jar";
    private static final String WAR = "war";
    private static final String EAR = "ear";
    private static final String SUBSCRIPTIONS = "subscriptions";

    public static String getArtifactCompileVersion(File artifact) throws AzureExecutionException {
        String string;
        JarFile jarFile = new JarFile(artifact);
        try {
            JarEntry jarEntry = jarFile.stream().filter(entry -> StringUtils.endsWith((CharSequence)entry.getName(), (CharSequence)".class")).findFirst().orElseThrow(() -> new AzureExecutionException("Failed to parse artifact compile version, no class file founded in target artifact"));
            InputStream stream = jarFile.getInputStream(jarEntry);
            byte[] version = new byte[2];
            stream.skip(6L);
            stream.read(version);
            stream.close();
            int majorVersion = new BigInteger(version).intValueExact() - 44;
            string = majorVersion > 8 ? String.valueOf(majorVersion) : String.format("1.%d", majorVersion);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AzureExecutionException("Failed to parse artifact compile version.", e);
            }
        }
        jarFile.close();
        return string;
    }

    public static boolean isGUID(String input) {
        try {
            return UUID.fromString(input).toString().equalsIgnoreCase(input);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSegment(String id, String segment) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Object[] attributes = StringUtils.lowerCase((String)id).split("/");
        int pos = ArrayUtils.indexOf((Object[])attributes, (Object)StringUtils.lowerCase((String)segment));
        if (pos >= 0) {
            return attributes[pos + 1];
        }
        return null;
    }

    public static String getSubscriptionId(String resourceId) {
        return Utils.getSegment(resourceId, SUBSCRIPTIONS);
    }

    public static boolean isPomPackagingProject(String packaging) {
        return POM.equalsIgnoreCase(packaging);
    }

    public static boolean isJarPackagingProject(String packaging) {
        return JAR.equalsIgnoreCase(packaging);
    }

    public static boolean isWarPackagingProject(String packaging) {
        return WAR.equalsIgnoreCase(packaging);
    }

    public static boolean isEarPackagingProject(String packaging) {
        return EAR.equalsIgnoreCase(packaging);
    }

    public static String calcXmlIndent(String[] lines, int row, int column) {
        Preconditions.checkNotNull((Object)lines, (Object)"The parameter 'lines' cannot be null");
        Preconditions.checkArgument((lines.length > row && row >= 0 ? 1 : 0) != 0, (Object)"The parameter 'row' overflows.");
        String line = lines[row];
        Preconditions.checkArgument((line != null ? 1 : 0) != 0, (Object)("Encounter null on row: " + row));
        Preconditions.checkArgument((line.length() >= column && column >= 0 ? 1 : 0) != 0, (Object)"The parameter 'column' overflows");
        StringBuilder buffer = new StringBuilder();
        int pos = line.lastIndexOf(60, column) - 1;
        for (int i = 0; i <= pos; ++i) {
            if (line.charAt(i) == '\t') {
                buffer.append('\t');
                continue;
            }
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static String executeCommandAndGetOutput(String cmd, File cwd) throws IOException, InterruptedException {
        String[] cmds = new String[]{isWindows ? "cmd.exe" : "bash", isWindows ? "/c" : "-c", cmd};
        Process p = Runtime.getRuntime().exec(cmds, null, cwd);
        int exitCode = p.waitFor();
        if (exitCode != 0) {
            String errorLog = IOUtils.toString((InputStream)p.getErrorStream(), (Charset)StandardCharsets.UTF_8);
            throw new CommandExecuteException(String.format("Cannot execute '%s' due to error: %s", cmd, errorLog));
        }
        return IOUtils.toString((InputStream)p.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public static Collection<String> intersectIgnoreCase(List<String> list1, List<String> list2) {
        if (CollectionUtils.isNotEmpty(list1) && CollectionUtils.isNotEmpty(list2)) {
            return list2.stream().filter(str -> Utils.containsIgnoreCase(list1, str)).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }

    public static boolean containsIgnoreCase(List<String> list, String str) {
        if (StringUtils.isNotBlank((CharSequence)str) && CollectionUtils.isNotEmpty(list)) {
            return list.stream().anyMatch(str2 -> StringUtils.equalsIgnoreCase((CharSequence)str, (CharSequence)str2));
        }
        return false;
    }

    public static String getId(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static <K, V> Map<K, V> groupByIgnoreDuplicate(Collection<V> list, Function<? super V, ? extends K> keyMapper) {
        return list.stream().collect(Collectors.toMap(keyMapper, item -> item, (item1, item2) -> item1));
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

