/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppInner;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.Container;
import com.azure.resourcemanager.appcontainers.models.Ingress;
import com.azure.resourcemanager.appcontainers.models.Template;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppModule;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.RevisionModule;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.model.IngressConfig;
import com.microsoft.azure.toolkit.lib.containerapps.model.RevisionMode;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerConsumer;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerModule;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ContainerApp
extends AbstractAzResource<ContainerApp, AzureContainerAppsServiceSubscription, com.azure.resourcemanager.appcontainers.models.ContainerApp>
implements Deletable,
StreamingLogSupport,
ServiceLinkerConsumer {
    public static final Action.Id<ContainerApp> BROWSE = Action.Id.of((String)"user/containerapps.open_in_browser.app");
    public static final Action.Id<ContainerApp> UPDATE_IMAGE = Action.Id.of((String)"user/containerapps.update_image.app");
    public static final String LOG_TYPE_CONSOLE = "console";
    public static final String LOG_TYPE_SYSTEM = "system";
    private final RevisionModule revisionModule;
    private Revision latestRevision = null;
    private final ServiceLinkerModule linkerModule;

    protected ContainerApp(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ContainerAppModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
        this.revisionModule = new RevisionModule(this);
        this.linkerModule = new ServiceLinkerModule(this.getId(), (ServiceLinkerConsumer)this);
    }

    protected ContainerApp(@Nonnull ContainerApp insight) {
        super((AbstractAzResource)insight);
        this.revisionModule = insight.revisionModule;
        this.linkerModule = insight.linkerModule;
        this.latestRevision = insight.latestRevision;
    }

    protected ContainerApp(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp remote, @Nonnull ContainerAppModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
        this.revisionModule = new RevisionModule(this);
        this.linkerModule = new ServiceLinkerModule(this.getId(), (ServiceLinkerConsumer)this);
    }

    protected void updateAdditionalProperties(@Nullable com.azure.resourcemanager.appcontainers.models.ContainerApp newRemote, @Nullable com.azure.resourcemanager.appcontainers.models.ContainerApp oldRemote) {
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
        this.latestRevision = Optional.ofNullable(newRemote).flatMap(c -> this.revisionModule.list().stream().filter(r -> Objects.equals(r.getName(), c.latestRevisionName())).findFirst()).orElse(null);
    }

    public void invalidateCache() {
        super.invalidateCache();
        this.latestRevision = null;
    }

    public RevisionModule revisions() {
        return this.revisionModule;
    }

    @Nullable
    public RevisionMode revisionModel() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.ContainerApp::configuration).map(Configuration::activeRevisionsMode).map(mode -> RevisionMode.fromString(mode.toString())).orElse(null);
    }

    @Nullable
    public IngressConfig getIngressConfig() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.ContainerApp::configuration).map(conf -> IngressConfig.fromIngress(conf.ingress())).orElse(null);
    }

    @Nullable
    public RevisionMode getRevisionMode() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.ContainerApp::configuration).map(Configuration::activeRevisionsMode).map(arm -> RevisionMode.fromString(arm.toString())).orElse(null);
    }

    @Nullable
    public Region getRegion() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(remote -> Region.fromName((String)remote.region().name())).orElse(null);
    }

    public boolean isIngressEnabled() {
        return this.remoteOptional().map(com.azure.resourcemanager.appcontainers.models.ContainerApp::configuration).map(Configuration::ingress).isPresent();
    }

    @Nullable
    public String getIngressFqdn() {
        return this.remoteOptional().map(com.azure.resourcemanager.appcontainers.models.ContainerApp::configuration).map(Configuration::ingress).map(Ingress::fqdn).orElse(null);
    }

    @Nullable
    public ContainerAppsEnvironment getManagedEnvironment() {
        String managedEnvironmentId = this.getManagedEnvironmentId();
        return StringUtils.isEmpty((CharSequence)managedEnvironmentId) ? null : (ContainerAppsEnvironment)((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(this.getSubscriptionId()).get(managedEnvironmentId);
    }

    @Nullable
    public String getManagedEnvironmentId() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.ContainerApp::managedEnvironmentId).orElse(null);
    }

    @Nullable
    public String getEnvironmentId() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.ContainerApp::environmentId).orElse(null);
    }

    @Nullable
    public String getLatestRevisionName() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.ContainerApp::latestRevisionName).orElse(null);
    }

    @Nullable
    public Revision getLatestRevision() {
        return Optional.ofNullable(this.getLatestRevisionName()).map(name -> (Revision)this.revisions().get((String)name, this.getResourceGroupName())).orElse(null);
    }

    @Nullable
    public Revision getCachedLatestRevision() {
        return this.latestRevision;
    }

    public void activate() {
        this.doModify(() -> Objects.requireNonNull(this.getLatestRevision()).activate(), "Activating");
    }

    public void deactivate() {
        this.doModify(() -> Objects.requireNonNull(this.getLatestRevision()).deactivate(), "Deactivating");
    }

    public void restart() {
        this.doModify(() -> Objects.requireNonNull(this.getLatestRevision()).restart(), "Restarting");
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Arrays.asList(new AbstractAzResourceModule[]{this.revisionModule, this.linkerModule});
    }

    @Nullable
    public String getProvisioningState() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).map(remote -> remote.provisioningState().toString()).orElse(null);
    }

    @Nonnull
    protected String loadStatus(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp remote) {
        return remote.provisioningState().toString();
    }

    @Nullable
    public String getManagedBy() {
        return this.remoteOptional().map(com.azure.resourcemanager.appcontainers.models.ContainerApp::managedBy).orElse(null);
    }

    @Nullable
    public AbstractAzResource<?, ?, ?> getManagedByResource() {
        return Optional.ofNullable(this.getManagedBy()).map(arg_0 -> ((Azure)Azure.az()).getById(arg_0)).orElse(null);
    }

    public boolean hasUnsupportedFeatures() {
        Optional<Template> opTemplate = this.remoteOptional().map(com.azure.resourcemanager.appcontainers.models.ContainerApp::innerModel).map(ContainerAppInner::template);
        List containers = opTemplate.map(Template::containers).filter(CollectionUtils::isNotEmpty).orElse(null);
        List volumes = opTemplate.map(Template::volumes).orElse(null);
        if (CollectionUtils.isNotEmpty((Collection)volumes)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)containers)) {
            if (containers.size() > 1) {
                return true;
            }
            Iterator iterator = containers.iterator();
            if (iterator.hasNext()) {
                Container container = (Container)iterator.next();
                return CollectionUtils.isNotEmpty((Collection)container.probes()) || CollectionUtils.isNotEmpty((Collection)container.volumeMounts()) || CollectionUtils.isNotEmpty((Collection)container.args());
            }
        }
        return false;
    }

    public List<Revision> getRevisions() {
        return this.revisionModule.list();
    }

    @Nullable
    public String getLogStreamEndpoint() {
        if (!this.exists()) {
            throw new AzureToolkitRuntimeException(AzureString.format((String)"resource ({0}) not found", (Object[])new Object[]{this.getName()}).toString());
        }
        String eventStreamEndpoint = Objects.requireNonNull((com.azure.resourcemanager.appcontainers.models.ContainerApp)this.getRemote()).eventStreamEndpoint();
        String baseUrl = eventStreamEndpoint.substring(0, eventStreamEndpoint.indexOf("/subscriptions/"));
        return String.format("%s/subscriptions/%s/resourceGroups/%s/containerApps/%s/eventstream", baseUrl, this.getSubscriptionId(), this.getResourceGroupName(), this.getName());
    }

    public String getLogStreamAuthorization() {
        ContainerAppsApiManager manager = (ContainerAppsApiManager)((AzureContainerAppsServiceSubscription)this.getParent()).getRemote();
        String authToken = Optional.ofNullable(manager).map(m -> m.containerApps().getAuthToken(this.getResourceGroupName(), this.getName()).token()).orElse(null);
        return "Bearer " + authToken;
    }

    public ServiceLinkerModule getServiceLinkerModule() {
        return this.linkerModule;
    }

    public RevisionModule getRevisionModule() {
        return this.revisionModule;
    }
}

