/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.resourcemanager.appcontainers.models.ReplicaContainer;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ReplicaContainerModule;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ReplicaModule;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class Replica
extends AbstractAzResource<Replica, Revision, com.azure.resourcemanager.appcontainers.models.Replica> {
    private final ReplicaContainerModule containerModule;

    protected Replica(@Nonnull String name, @Nonnull ReplicaModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.containerModule = new ReplicaContainerModule(this);
    }

    protected Replica(@Nonnull Replica origin) {
        super((AbstractAzResource)origin);
        this.containerModule = origin.containerModule;
    }

    protected Replica(@Nonnull com.azure.resourcemanager.appcontainers.models.Replica remote, @Nonnull ReplicaModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
        this.containerModule = new ReplicaContainerModule(this);
    }

    @NotNull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.containerModule);
    }

    @NotNull
    protected String loadStatus(@NotNull com.azure.resourcemanager.appcontainers.models.Replica remote) {
        return "OK";
    }

    public List<ReplicaContainer> getContainers() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Replica)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.Replica::containers).orElse(Collections.emptyList());
    }

    public ReplicaContainerModule getContainerModule() {
        return this.containerModule;
    }
}

