/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.core.util.paging.ContinuablePage;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Replica;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ReplicaContainer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReplicaContainerModule
extends AbstractAzResourceModule<ReplicaContainer, Replica, com.azure.resourcemanager.appcontainers.models.ReplicaContainer> {
    public static final String NAME = "containers";

    public ReplicaContainerModule(@Nonnull Replica parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected ReplicaContainer newResource(@Nonnull com.azure.resourcemanager.appcontainers.models.ReplicaContainer remote) {
        return new ReplicaContainer(remote, this);
    }

    @Nonnull
    protected ReplicaContainer newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ReplicaContainer(name, this);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, com.azure.resourcemanager.appcontainers.models.ReplicaContainer>> loadResourcePagesFromAzure() {
        Stream containers = Optional.of((Replica)this.getParent()).map(AbstractAzResource::getRemote).map(c -> c.containers().stream()).orElse(Stream.empty());
        return Collections.singletonList(new ItemPage(containers)).iterator();
    }

    @Nullable
    protected com.azure.resourcemanager.appcontainers.models.ReplicaContainer loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        return Optional.of((Replica)this.getParent()).map(AbstractAzResource::getRemote).flatMap(r -> r.containers().stream().filter(c -> c.name().equalsIgnoreCase(name)).findAny()).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Replica Container";
    }
}

