/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisions;
import com.azure.resourcemanager.appcontainers.models.RevisionHealthState;
import com.azure.resourcemanager.appcontainers.models.RevisionProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Replica;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ReplicaModule;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.RevisionModule;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class Revision
extends AbstractAzResource<Revision, ContainerApp, com.azure.resourcemanager.appcontainers.models.Revision>
implements Deletable {
    private final ReplicaModule replicaModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    protected Revision(@Nonnull String name, @Nonnull AbstractAzResourceModule<Revision, ContainerApp, com.azure.resourcemanager.appcontainers.models.Revision> module) {
        super(name, module);
        this.replicaModule = new ReplicaModule(this);
    }

    protected Revision(@Nonnull Revision insight) {
        super((AbstractAzResource)insight);
        this.replicaModule = insight.replicaModule;
    }

    protected Revision(@Nonnull com.azure.resourcemanager.appcontainers.models.Revision remote, @Nonnull RevisionModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
        this.replicaModule = new ReplicaModule(this);
    }

    @AzureOperation(name="azure/containerapps.activate_revision.revision", params={"this.getName()"})
    public void activate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerApp parent = (ContainerApp)this.getParent();
            this.doModify(() -> {
                Objects.requireNonNull(this.getClient()).activateRevision(parent.getResourceGroupName(), parent.getName(), this.getName());
                this.getModule().refresh();
            }, "Activating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/containerapps.deactivate_revision.revision", params={"this.getName()"})
    public void deactivate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerApp parent = (ContainerApp)this.getParent();
            this.doModify(() -> {
                Objects.requireNonNull(this.getClient()).deactivateRevision(parent.getResourceGroupName(), parent.getName(), this.getName());
                this.getModule().refresh();
            }, "Deactivating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/containerapps.restart_revision.revision", params={"this.getName()"})
    public void restart() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerApp parent = (ContainerApp)this.getParent();
            this.doModify(() -> {
                Objects.requireNonNull(this.getClient()).restartRevision(parent.getResourceGroupName(), parent.getName(), this.getName());
                this.getModule().refresh();
            }, "Restarting");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public OffsetDateTime getCreatedTime() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Revision)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.Revision::createdTime).orElse(null);
    }

    @Nullable
    public OffsetDateTime getLastActiveTime() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Revision)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.Revision::lastActiveTime).orElse(null);
    }

    @Nullable
    public String getFqdn() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Revision)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.Revision::fqdn).orElse(null);
    }

    @Nullable
    public String getProvisioningState() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Revision)this.getRemote()).map(remote -> remote.provisioningState().toString()).orElse(null);
    }

    @Nullable
    public Integer getTrafficWeight() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Revision)this.getRemote()).map(remote -> remote.innerModel().trafficWeight()).orElse(null);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.replicaModule);
    }

    public boolean isActive() {
        return Optional.ofNullable((com.azure.resourcemanager.appcontainers.models.Revision)this.getRemote()).map(com.azure.resourcemanager.appcontainers.models.Revision::active).orElse(false);
    }

    @Nonnull
    protected String loadStatus(@Nonnull com.azure.resourcemanager.appcontainers.models.Revision remote) {
        RevisionProvisioningState provisioningState = remote.provisioningState();
        if (provisioningState == RevisionProvisioningState.PROVISIONED) {
            RevisionHealthState healthState = remote.healthState();
            if (healthState == RevisionHealthState.HEALTHY && !remote.active().booleanValue()) {
                return "Stopped";
            }
            return healthState.toString();
        }
        return provisioningState.toString();
    }

    public List<Replica> getReplicas() {
        return this.replicaModule.list();
    }

    @Nullable
    private ContainerAppsRevisions getClient() {
        return ((RevisionModule)this.getModule()).getClient();
    }

    public ReplicaModule getReplicaModule() {
        return this.replicaModule;
    }

    static {
        Revision.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Revision.java", Revision.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "activate", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision", "", "", "", "void"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deactivate", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision", "", "", "", "void"), 56);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restart", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision", "", "", "", "void"), 65);
    }
}

