/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.environment;

import com.azure.resourcemanager.appcontainers.models.AppLogsConfiguration;
import com.azure.resourcemanager.appcontainers.models.LogAnalyticsConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironments;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppsEnvironmentDraft
extends ContainerAppsEnvironment
implements AzResource.Draft<ContainerAppsEnvironment, ManagedEnvironment> {
    private final ContainerAppsEnvironment origin;
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected ContainerAppsEnvironmentDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ContainerAppsEnvironmentModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    public ContainerAppsEnvironmentDraft(@Nonnull ContainerAppsEnvironment origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    @Nonnull
    @AzureOperation(name="azure/containerapps.create_environment.env", params={"this.getName()"})
    public ManagedEnvironment createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            IAzureMessager messager = AzureMessager.getMessager();
            ManagedEnvironments client = Objects.requireNonNull(((ContainerAppsEnvironmentModule)this.getModule()).getClient());
            Config config = this.ensureConfig();
            AppLogsConfiguration appLogsConfiguration = new AppLogsConfiguration();
            LogAnalyticsWorkspace logAnalyticsWorkspace = config.getLogAnalyticsWorkspace();
            if (Objects.nonNull(logAnalyticsWorkspace)) {
                if (logAnalyticsWorkspace.isDraftForCreating() && !logAnalyticsWorkspace.exists()) {
                    ((LogAnalyticsWorkspaceDraft)logAnalyticsWorkspace).commit();
                }
                LogAnalyticsConfiguration analyticsConfiguration = new LogAnalyticsConfiguration().withCustomerId(logAnalyticsWorkspace.getCustomerId()).withSharedKey(logAnalyticsWorkspace.getPrimarySharedKeys());
                appLogsConfiguration.withDestination("log-analytics").withLogAnalyticsConfiguration(analyticsConfiguration);
            }
            messager.info(AzureString.format((String)"Start creating Azure Container Apps Environment({0})...", (Object[])new Object[]{this.getName()}));
            ManagedEnvironment managedEnvironment = client.define(config.getName()).withRegion(com.azure.core.management.Region.fromName((String)config.getRegion().getName())).withExistingResourceGroup(Objects.requireNonNull(config.getResourceGroup(), "Resource Group is required to create Container app.").getResourceGroupName()).withAppLogsConfiguration(appLogsConfiguration).create();
            Action create = Optional.ofNullable(AzureActionManager.getInstance().getAction(CREATE_CONTAINER_APP)).map(action -> action.bind((Object)this).withLabel("Create app")).orElse(null);
            messager.success(AzureString.format((String)"Azure Container Apps Environment({0}) is successfully created.", (Object[])new Object[]{this.getName()}), new Object[]{create});
            ManagedEnvironment managedEnvironment2 = managedEnvironment;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return managedEnvironment2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public ManagedEnvironment updateResourceInAzure(@Nonnull ManagedEnvironment origin) {
        throw new UnsupportedOperationException("not support");
    }

    public boolean isModified() {
        return this.config != null && !Objects.equals(this.config, new Config());
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public ContainerAppsEnvironment getOrigin() {
        return this.origin;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    static {
        ContainerAppsEnvironmentDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppsEnvironmentDraft.java", ContainerAppsEnvironmentDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft", "", "", "", "com.azure.resourcemanager.appcontainers.models.ManagedEnvironment"), 66);
    }

    public static class Config {
        private String name;
        private Subscription subscription;
        private ResourceGroup resourceGroup;
        private Region region;
        private LogAnalyticsWorkspace logAnalyticsWorkspace;

        public String getName() {
            return this.name;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        public Region getRegion() {
            return this.region;
        }

        public LogAnalyticsWorkspace getLogAnalyticsWorkspace() {
            return this.logAnalyticsWorkspace;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public void setResourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public void setLogAnalyticsWorkspace(LogAnalyticsWorkspace logAnalyticsWorkspace) {
            this.logAnalyticsWorkspace = logAnalyticsWorkspace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Subscription this$subscription = this.getSubscription();
            Subscription other$subscription = other.getSubscription();
            if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
                return false;
            }
            ResourceGroup this$resourceGroup = this.getResourceGroup();
            ResourceGroup other$resourceGroup = other.getResourceGroup();
            if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            LogAnalyticsWorkspace this$logAnalyticsWorkspace = this.getLogAnalyticsWorkspace();
            LogAnalyticsWorkspace other$logAnalyticsWorkspace = other.getLogAnalyticsWorkspace();
            return !(this$logAnalyticsWorkspace == null ? other$logAnalyticsWorkspace != null : !this$logAnalyticsWorkspace.equals(other$logAnalyticsWorkspace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Subscription $subscription = this.getSubscription();
            result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
            ResourceGroup $resourceGroup = this.getResourceGroup();
            result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            LogAnalyticsWorkspace $logAnalyticsWorkspace = this.getLogAnalyticsWorkspace();
            result = result * 59 + ($logAnalyticsWorkspace == null ? 43 : $logAnalyticsWorkspace.hashCode());
            return result;
        }

        public String toString() {
            return "ContainerAppsEnvironmentDraft.Config(name=" + this.getName() + ", subscription=" + this.getSubscription() + ", resourceGroup=" + this.getResourceGroup() + ", region=" + this.getRegion() + ", logAnalyticsWorkspace=" + this.getLogAnalyticsWorkspace() + ")";
        }
    }
}

