/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.model;

import com.azure.resourcemanager.appcontainers.fluent.models.AvailableWorkloadProfileInner;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfile;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfileProperties;
import java.util.Optional;
import javax.annotation.Nonnull;

public class WorkloadProfileType {
    public static final WorkloadProfileType CONSUMPTION_TYPE = WorkloadProfileType.builder().name("Consumption").build();
    private final String name;
    private final String category;
    private final String displayName;
    private final Integer cores;
    private final Integer memory;

    public static WorkloadProfileType fromAvailableProfile(@Nonnull AvailableWorkloadProfile profile) {
        AvailableWorkloadProfileProperties properties = Optional.ofNullable(profile.innerModel()).map(AvailableWorkloadProfileInner::properties).orElse(null);
        return WorkloadProfileType.builder().name(profile.name()).category(Optional.ofNullable(properties).map(AvailableWorkloadProfileProperties::category).orElse(null)).displayName(Optional.ofNullable(properties).map(AvailableWorkloadProfileProperties::displayName).orElse(null)).cores(Optional.ofNullable(properties).map(AvailableWorkloadProfileProperties::cores).orElse(null)).memory(Optional.ofNullable(properties).map(AvailableWorkloadProfileProperties::memoryGiB).orElse(null)).build();
    }

    public static WorkloadProfileTypeBuilder builder() {
        return new WorkloadProfileTypeBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getCores() {
        return this.cores;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public String toString() {
        return "WorkloadProfileType(name=" + this.getName() + ", category=" + this.getCategory() + ", displayName=" + this.getDisplayName() + ", cores=" + this.getCores() + ", memory=" + this.getMemory() + ")";
    }

    public WorkloadProfileType(String name, String category, String displayName, Integer cores, Integer memory) {
        this.name = name;
        this.category = category;
        this.displayName = displayName;
        this.cores = cores;
        this.memory = memory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkloadProfileType)) {
            return false;
        }
        WorkloadProfileType other = (WorkloadProfileType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cores = this.getCores();
        Integer other$cores = other.getCores();
        if (this$cores == null ? other$cores != null : !((Object)this$cores).equals(other$cores)) {
            return false;
        }
        Integer this$memory = this.getMemory();
        Integer other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkloadProfileType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cores = this.getCores();
        result = result * 59 + ($cores == null ? 43 : ((Object)$cores).hashCode());
        Integer $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public static class WorkloadProfileTypeBuilder {
        private String name;
        private String category;
        private String displayName;
        private Integer cores;
        private Integer memory;

        WorkloadProfileTypeBuilder() {
        }

        public WorkloadProfileTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkloadProfileTypeBuilder category(String category) {
            this.category = category;
            return this;
        }

        public WorkloadProfileTypeBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public WorkloadProfileTypeBuilder cores(Integer cores) {
            this.cores = cores;
            return this;
        }

        public WorkloadProfileTypeBuilder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public WorkloadProfileType build() {
            return new WorkloadProfileType(this.name, this.category, this.displayName, this.cores, this.memory);
        }

        public String toString() {
            return "WorkloadProfileType.WorkloadProfileTypeBuilder(name=" + this.name + ", category=" + this.category + ", displayName=" + this.displayName + ", cores=" + this.cores + ", memory=" + this.memory + ")";
        }
    }
}

