/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.policy.ProviderRegistrationPolicy;
import com.azure.resourcemanager.resources.models.Providers;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzService;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppModule;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureContainerApps
extends AbstractAzService<AzureContainerAppsServiceSubscription, ContainerAppsApiManager> {
    public AzureContainerApps() {
        super("Microsoft.App");
    }

    @Nonnull
    protected AzureContainerAppsServiceSubscription newResource(@Nonnull ContainerAppsApiManager containerAppsApiManager) {
        return new AzureContainerAppsServiceSubscription(containerAppsApiManager.serviceClient().getSubscriptionId(), (AbstractAzResourceModule<AzureContainerAppsServiceSubscription, AzResource.None, ContainerAppsApiManager>)this);
    }

    public ContainerAppModule containerApps(@Nonnull String subscriptionId) {
        AzureContainerAppsServiceSubscription rm = (AzureContainerAppsServiceSubscription)this.get(subscriptionId, null);
        return Objects.requireNonNull(rm).containerApps();
    }

    public ContainerAppsEnvironmentModule environments(@Nonnull String subscriptionId) {
        AzureContainerAppsServiceSubscription rm = (AzureContainerAppsServiceSubscription)this.get(subscriptionId, null);
        return Objects.requireNonNull(rm).environments();
    }

    @Nullable
    protected ContainerAppsApiManager loadResourceFromAzure(@Nonnull String subscriptionId, @Nullable String resourceGroup) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        String tenantId = account.getSubscription(subscriptionId).getTenantId();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogOptions logOptions = new HttpLogOptions();
        logOptions.setLogLevel(Optional.ofNullable(config.getLogLevel()).map(HttpLogDetailLevel::valueOf).orElse(HttpLogDetailLevel.NONE));
        AzureProfile azureProfile = new AzureProfile(tenantId, subscriptionId, account.getEnvironment());
        Providers providers = ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient())).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId).providers();
        return ContainerAppsApiManager.configure().withHttpClient(AbstractAzServiceSubscription.getDefaultHttpClient()).withLogOptions(logOptions).withPolicy(AbstractAzServiceSubscription.getUserAgentPolicy((String)userAgent)).withPolicy((HttpPipelinePolicy)new ProviderRegistrationPolicy(providers)).authenticate(account.getTokenCredential(subscriptionId), azureProfile);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Container Apps";
    }

    public String getServiceNameForTelemetry() {
        return "containerapps";
    }
}

