/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.task;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.config.ContainerAppConfig;
import com.microsoft.azure.toolkit.lib.containerapps.config.ContainerAppsEnvironmentConfig;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft;
import com.microsoft.azure.toolkit.lib.containerregistry.config.ContainerRegistryConfig;
import com.microsoft.azure.toolkit.lib.containerregistry.model.Sku;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.task.CreateResourceGroupTask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class DeployContainerAppTask
extends AzureTask<ContainerApp> {
    private final ContainerAppConfig config;
    private ContainerApp containerApp;
    @Nonnull
    private final List<AzureTask<?>> subTasks;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DeployContainerAppTask(ContainerAppConfig config) {
        this.config = config;
        this.subTasks = new ArrayList();
        this.initTasks();
    }

    private void initTasks() {
        ContainerAppsEnvironmentConfig environmentConfig = this.config.getEnvironment();
        this.preCheck(environmentConfig);
        this.addCreateResourceGroupTaskIfNecessary(environmentConfig);
        this.addCreateAppEnvironmentTaskIfNecessary(environmentConfig);
        this.addCreateContainerRegistryTaskIfNecessary(this.config.getRegistryConfig());
        this.addCreateOrUpdateContainerAppTask();
    }

    private void preCheck(ContainerAppsEnvironmentConfig environmentConfig) {
        DeployContainerAppTask.checkNotBlank(environmentConfig, ContainerAppsEnvironmentConfig::getSubscriptionId, "subscriptionId");
        DeployContainerAppTask.checkNotBlank(environmentConfig, ContainerAppsEnvironmentConfig::getAppEnvironmentName, "environmentName");
        DeployContainerAppTask.checkNotBlank(this.config, ContainerAppConfig::getAppName, "appName");
        DeployContainerAppTask.checkNotBlank(environmentConfig, ContainerAppsEnvironmentConfig::getResourceGroup, "resourceGroup");
    }

    private void addCreateResourceGroupTaskIfNecessary(@Nonnull ContainerAppsEnvironmentConfig config) {
        ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(config.getSubscriptionId()).getOrDraft(config.getResourceGroup(), config.getResourceGroup());
        if (resourceGroup.isDraftForCreating() && !resourceGroup.exists()) {
            String region = DeployContainerAppTask.checkNotBlank(config, ContainerAppsEnvironmentConfig::getRegion, "region");
            this.subTasks.add((AzureTask<?>)new CreateResourceGroupTask(config.getSubscriptionId(), config.getResourceGroup(), Region.fromName((String)region)));
        }
    }

    private void addCreateAppEnvironmentTaskIfNecessary(@Nonnull ContainerAppsEnvironmentConfig config) {
        ContainerAppsEnvironment environment = (ContainerAppsEnvironment)((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(config.getSubscriptionId()).getOrDraft(config.getAppEnvironmentName(), config.getResourceGroup());
        if (environment.isDraftForCreating() && !environment.exists()) {
            AzureString title = AzureString.format((String)"Create new Container Apps Environment({0})", (Object[])new Object[]{environment.getName()});
            this.subTasks.add(new AzureTask(title, () -> {
                ResourceGroup resourceGroup = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(config.getSubscriptionId()).get(config.getResourceGroup(), config.getResourceGroup());
                ContainerAppsEnvironmentDraft draft = (ContainerAppsEnvironmentDraft)environment;
                ContainerAppsEnvironmentDraft.Config draftConfig = new ContainerAppsEnvironmentDraft.Config();
                draftConfig.setName(config.getAppEnvironmentName());
                draftConfig.setResourceGroup(resourceGroup);
                draftConfig.setRegion(Region.fromName((String)config.getRegion()));
                draft.setConfig(draftConfig);
                draft.commit();
            }));
        }
    }

    private void addCreateContainerRegistryTaskIfNecessary(@Nonnull ContainerRegistryConfig containerRegistryConfig) {
        ContainerRegistry registry = (ContainerRegistry)((AzureContainerRegistry)Azure.az(AzureContainerRegistry.class)).registry(containerRegistryConfig.getSubscriptionId()).getOrDraft(containerRegistryConfig.getRegistryName(), containerRegistryConfig.getResourceGroup());
        if (registry.isDraftForCreating() && !registry.exists()) {
            AzureString title = AzureString.format((String)"Create new Container Registry({0})", (Object[])new Object[]{registry.getName()});
            this.subTasks.add(new AzureTask(title, () -> {
                ContainerRegistryDraft draft = (ContainerRegistryDraft)registry;
                draft.setRegion(Region.fromName((String)containerRegistryConfig.getRegion()));
                draft.setSku(Sku.Standard);
                draft.setAdminUserEnabled(Boolean.valueOf(true));
                this.config.getImageConfig().setContainerRegistry((ContainerRegistry)draft.commit());
            }));
        } else {
            this.config.getImageConfig().setContainerRegistry(registry);
        }
    }

    private void addCreateOrUpdateContainerAppTask() {
        ContainerAppDraft containerAppDraft = (ContainerAppDraft)((AzureContainerApps)Azure.az(AzureContainerApps.class)).containerApps(this.config.getEnvironment().getSubscriptionId()).updateOrCreate(this.config.getAppName(), this.config.getEnvironment().getResourceGroup());
        AzureString title = AzureString.format((String)"Create or update Container App({0})", (Object[])new Object[]{this.config.getAppName()});
        this.subTasks.add(new AzureTask(title, () -> {
            containerAppDraft.setConfig(this.toContainerAppDraftConfig());
            this.containerApp = (ContainerApp)containerAppDraft.commit();
        }));
    }

    private ContainerAppDraft.Config toContainerAppDraftConfig() {
        ContainerAppDraft.Config draftConfig = new ContainerAppDraft.Config();
        ContainerAppsEnvironmentConfig environmentConfig = this.config.getEnvironment();
        ContainerAppsEnvironment environment = (ContainerAppsEnvironment)((AzureContainerApps)Azure.az(AzureContainerApps.class)).environments(environmentConfig.getSubscriptionId()).get(environmentConfig.getAppEnvironmentName(), environmentConfig.getResourceGroup());
        draftConfig.setEnvironment(environment);
        draftConfig.setSubscription(environment.getSubscription());
        draftConfig.setResourceGroup(environment.getResourceGroup());
        draftConfig.setName(this.config.getAppName());
        draftConfig.setImageConfig(this.config.getImageConfig());
        draftConfig.setIngressConfig(this.config.getIngressConfig());
        draftConfig.setResourceConfiguration(this.config.getResourceConfiguration());
        draftConfig.setScaleConfig(this.config.getScaleConfig());
        return draftConfig;
    }

    @AzureOperation(name="internal/containerapps.create_update_app.app", params={"this.config.getAppName()"})
    public ContainerApp doExecute() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            for (AzureTask<?> t : this.subTasks) {
                t.getBody().call();
            }
            ContainerApp containerApp = this.containerApp;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return containerApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private static <T> String checkNotBlank(T config, Function<T, String> getter, String name) {
        String value;
        if (config != null && StringUtils.isNotBlank((CharSequence)(value = getter.apply(config)))) {
            return value;
        }
        throw new AzureToolkitRuntimeException(String.format("'%s' is required", name));
    }

    static {
        DeployContainerAppTask.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployContainerAppTask.java", DeployContainerAppTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doExecute", "com.microsoft.azure.toolkit.lib.containerapps.task.DeployContainerAppTask", "", "", "java.lang.Exception", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp"), 135);
    }
}

