/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.models.ContainerApps;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppModule
extends AbstractAzResourceModule<ContainerApp, AzureContainerAppsServiceSubscription, com.azure.resourcemanager.appcontainers.models.ContainerApp> {
    public static final String NAME = "containerApps";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ContainerAppModule(@Nonnull AzureContainerAppsServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, com.azure.resourcemanager.appcontainers.models.ContainerApp>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.list().iterableByPage(ContainerAppModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    @AzureOperation(name="azure/containerapps.load_app.app", params={"name"})
    protected com.azure.resourcemanager.appcontainers.models.ContainerApp loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp = Optional.ofNullable(this.getClient()).map(client -> client.getByResourceGroup(resourceGroup, name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return containerApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/containerapps.delete_app.app", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId id = ResourceId.fromString((String)resourceId);
            Optional.ofNullable(this.getClient()).ifPresent(client -> client.deleteByResourceGroup(id.resourceGroupName(), id.name()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected ContainerAppDraft newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        assert (rgName != null) : "'Resource group' is required.";
        return new ContainerAppDraft(name, rgName, this);
    }

    @Nonnull
    protected ContainerAppDraft newDraftForUpdate(@Nonnull ContainerApp containerApp) {
        return new ContainerAppDraft(containerApp);
    }

    @Nonnull
    protected ContainerApp newResource(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp) {
        return new ContainerApp(containerApp, this);
    }

    @Nonnull
    protected ContainerApp newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new ContainerApp(name, resourceGroupName, this);
    }

    public List<ContainerApp> listContainerAppsByEnvironment(@Nonnull ContainerAppsEnvironment environment) {
        return this.listContainerAppsByEnvironment(environment.getId());
    }

    public List<ContainerApp> listContainerAppsByEnvironment(@Nonnull String environment) {
        return this.list().stream().filter(app -> StringUtils.equalsIgnoreCase((CharSequence)app.getManagedEnvironmentId(), (CharSequence)environment)).collect(Collectors.toList());
    }

    @Nullable
    public ContainerApps getClient() {
        return Optional.ofNullable(((AzureContainerAppsServiceSubscription)this.parent).getRemote()).map(ContainerAppsApiManager::containerApps).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Container App";
    }

    static {
        ContainerAppModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppModule.java", ContainerAppModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.appcontainers.models.ContainerApp"), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppModule", "java.lang.String", "resourceId", "", "void"), 49);
    }
}

