/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisionReplicas;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Replica;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.Revision;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReplicaModule
extends AbstractAzResourceModule<Replica, Revision, com.azure.resourcemanager.appcontainers.models.Replica> {
    public static final String NAME = "replicas";

    public ReplicaModule(@Nonnull Revision parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Replica newResource(@Nonnull com.azure.resourcemanager.appcontainers.models.Replica remote) {
        return new Replica(remote, this);
    }

    @Nonnull
    protected Replica newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Replica(name, this);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, com.azure.resourcemanager.appcontainers.models.Replica>> loadResourcePagesFromAzure() {
        ContainerApp containerApp = (ContainerApp)((Revision)this.getParent()).getParent();
        Stream replicaStream = Optional.ofNullable(this.getClient()).map(c -> c.listReplicas(containerApp.getResourceGroupName(), containerApp.getName(), ((Revision)this.parent).getName()).value().stream()).orElse(Stream.empty());
        return Collections.singletonList(new ItemPage(replicaStream)).iterator();
    }

    @Nullable
    protected com.azure.resourcemanager.appcontainers.models.Replica loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        return Optional.ofNullable(this.getClient()).map(client -> client.getReplica(((Revision)this.parent).getResourceGroupName(), ((ContainerApp)((Revision)this.parent).getParent()).getName(), ((Revision)this.parent).getName(), name)).orElse(null);
    }

    @Nullable
    protected ContainerAppsRevisionReplicas getClient() {
        ContainerAppsApiManager remote = (ContainerAppsApiManager)((AzureContainerAppsServiceSubscription)((ContainerApp)((Revision)this.getParent()).getParent()).getParent()).getRemote();
        return Optional.ofNullable(remote).map(ContainerAppsApiManager::containerAppsRevisionReplicas).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Replica";
    }
}

