/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Registry;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft;
import com.microsoft.azure.toolkit.lib.containerregistry.RepositoryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.model.Sku;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerRegistry
extends AbstractAzResource<ContainerRegistry, AzureContainerRegistryServiceSubscription, Registry> {
    private final RepositoryModule repositoryModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected ContainerRegistry(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AzureContainerRegistryModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
        this.repositoryModule = new RepositoryModule(this);
    }

    protected ContainerRegistry(@Nonnull ContainerRegistry registry) {
        super((AbstractAzResource)registry);
        this.repositoryModule = registry.repositoryModule;
    }

    protected ContainerRegistry(@Nonnull Registry registry, @Nonnull AzureContainerRegistryModule module) {
        super(registry.name(), registry.resourceGroupName(), (AbstractAzResourceModule)module);
        this.repositoryModule = new RepositoryModule(this);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.repositoryModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull Registry remote) {
        return Optional.ofNullable((RegistryInner)remote.innerModel()).map(RegistryInner::provisioningState).map(ExpandableStringEnum::toString).orElse("Unknown");
    }

    public boolean isAdminUserEnabled() {
        return this.remoteOptional().map(Registry::adminUserEnabled).orElse(false);
    }

    public boolean isPublicAccessEnabled() {
        return this.remoteOptional().map(r -> r.publicNetworkAccess() == PublicNetworkAccess.ENABLED).orElse(true);
    }

    @AzureOperation(name="internal/acr.enable_admin_user.registry", params={"this.getName()"})
    public void enableAdminUser() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerRegistryDraft update = (ContainerRegistryDraft)this.update();
            update.setAdminUserEnabled(true);
            update.commit();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="internal/acr.disable_admin_user.registry", params={"this.getName()"})
    public void disableAdminUser() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerRegistryDraft update = (ContainerRegistryDraft)this.update();
            update.setAdminUserEnabled(false);
            update.commit();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nullable
    public Sku getSku() {
        return this.remoteOptional().map(Registry::sku).map(sku -> sku.tier().toString()).map(Sku::valueOf).orElse(null);
    }

    @Nullable
    public Region getRegion() {
        return this.remoteOptional().map(registry -> registry.region().name()).map(Region::fromName).orElse(null);
    }

    @Nullable
    public String getUserName() {
        return this.remoteOptional().map(registry -> registry.getCredentials().username()).orElse(null);
    }

    @Nullable
    public String getPrimaryCredential() {
        return this.remoteOptional().map(registry -> registry.getCredentials().accessKeys()).map(map -> (String)map.get(AccessKeyType.PRIMARY)).orElse(null);
    }

    @Nullable
    public String getSecondaryCredential() {
        return this.remoteOptional().map(registry -> registry.getCredentials().accessKeys()).map(map -> (String)map.get(AccessKeyType.SECONDARY)).orElse(null);
    }

    @Nullable
    public String getLoginServerUrl() {
        return this.remoteOptional().map(Registry::loginServerUrl).orElse(null);
    }

    @Nullable
    public String getType() {
        return this.remoteOptional().map(Resource::type).orElse(null);
    }

    public RepositoryModule getRepositoryModule() {
        return this.repositoryModule;
    }

    static {
        ContainerRegistry.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerRegistry.java", ContainerRegistry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableAdminUser", "com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry", "", "", "", "void"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableAdminUser", "com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry", "", "", "", "void"), 74);
    }
}

