/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.containers.containerregistry.models.ArtifactTagProperties;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.containerregistry.Artifact;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.Repository;
import com.microsoft.azure.toolkit.lib.containerregistry.TagModule;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class Tag
extends AbstractAzResource<Tag, Artifact, ArtifactTagProperties>
implements Deletable {
    protected Tag(@Nonnull String name, @Nonnull TagModule module) {
        super(name, (AbstractAzResourceModule)module);
    }

    protected Tag(@Nonnull Tag tag) {
        super((AbstractAzResource)tag);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    protected String loadStatus(@Nonnull ArtifactTagProperties remote) {
        return "OK";
    }

    @Nonnull
    public String getPortalUrl() {
        IAccount account = ((IAzureAccount)Azure.az(IAzureAccount.class)).account();
        Repository repository = (Repository)((Artifact)this.getParent()).getParent();
        ContainerRegistry registry = (ContainerRegistry)repository.getParent();
        String encodedRegistryId = URLEncoder.encode(registry.getId(), "UTF-8");
        String encodedRepositoryName = URLEncoder.encode(repository.getName(), "UTF-8");
        return String.format("%s/#blade/Microsoft_Azure_ContainerRegistries/TagMetadataBlade/registryId/%s/repositoryName/%s/tag/%s", account.getPortalUrl(), encodedRegistryId, encodedRepositoryName, this.getName());
    }

    @Nonnull
    public String getDigest() {
        return this.remoteOptional().map(ArtifactTagProperties::getDigest).orElse("");
    }

    @Nonnull
    public OffsetDateTime getLastUpdatedOn() {
        return this.remoteOptional().map(ArtifactTagProperties::getLastUpdatedOn).orElse(OffsetDateTime.MIN);
    }

    public String getFullName() {
        Repository repository = (Repository)((Artifact)this.getParent()).getParent();
        ContainerRegistry registry = (ContainerRegistry)repository.getParent();
        return String.format("%s/%s:%s", registry.getLoginServerUrl(), repository.getName(), this.getName());
    }

    public String getImageName() {
        Repository repository = (Repository)((Artifact)this.getParent()).getParent();
        return String.format("%s:%s", repository.getName(), this.getName());
    }
}

