/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.database;

import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatabaseServerConfig {
    @Nonnull
    private String name;
    @Nullable
    private ResourceGroup resourceGroup;
    @Nullable
    private Subscription subscription;
    @Nonnull
    private Region region;
    private String adminName;
    private String adminPassword;
    private String version;
    private String fullyQualifiedDomainName;
    private boolean azureServiceAccessAllowed;
    private boolean localMachineAccessAllowed;

    @Nullable
    public String getSubscriptionId() {
        return Objects.nonNull(this.subscription) ? this.subscription.getId() : null;
    }

    @Nullable
    public String getResourceGroupName() {
        return Objects.nonNull(this.resourceGroup) ? this.resourceGroup.getName() : null;
    }

    public DatabaseServerConfig(@Nonnull String name, @Nonnull Region region) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        this.name = name;
        this.region = region;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    @Nullable
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Nonnull
    public Region getRegion() {
        return this.region;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public boolean isAzureServiceAccessAllowed() {
        return this.azureServiceAccessAllowed;
    }

    public boolean isLocalMachineAccessAllowed() {
        return this.localMachineAccessAllowed;
    }

    public void setName(@Nonnull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setResourceGroup(@Nullable ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setSubscription(@Nullable Subscription subscription) {
        this.subscription = subscription;
    }

    public void setRegion(@Nonnull Region region) {
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        this.region = region;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
    }

    public void setAzureServiceAccessAllowed(boolean azureServiceAccessAllowed) {
        this.azureServiceAccessAllowed = azureServiceAccessAllowed;
    }

    public void setLocalMachineAccessAllowed(boolean localMachineAccessAllowed) {
        this.localMachineAccessAllowed = localMachineAccessAllowed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseServerConfig)) {
            return false;
        }
        DatabaseServerConfig other = (DatabaseServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAzureServiceAccessAllowed() != other.isAzureServiceAccessAllowed()) {
            return false;
        }
        if (this.isLocalMachineAccessAllowed() != other.isLocalMachineAccessAllowed()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ResourceGroup this$resourceGroup = this.getResourceGroup();
        ResourceGroup other$resourceGroup = other.getResourceGroup();
        if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
            return false;
        }
        Subscription this$subscription = this.getSubscription();
        Subscription other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        Region this$region = this.getRegion();
        Region other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$adminName = this.getAdminName();
        String other$adminName = other.getAdminName();
        if (this$adminName == null ? other$adminName != null : !this$adminName.equals(other$adminName)) {
            return false;
        }
        String this$adminPassword = this.getAdminPassword();
        String other$adminPassword = other.getAdminPassword();
        if (this$adminPassword == null ? other$adminPassword != null : !this$adminPassword.equals(other$adminPassword)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$fullyQualifiedDomainName = this.getFullyQualifiedDomainName();
        String other$fullyQualifiedDomainName = other.getFullyQualifiedDomainName();
        return !(this$fullyQualifiedDomainName == null ? other$fullyQualifiedDomainName != null : !this$fullyQualifiedDomainName.equals(other$fullyQualifiedDomainName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAzureServiceAccessAllowed() ? 79 : 97);
        result = result * 59 + (this.isLocalMachineAccessAllowed() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ResourceGroup $resourceGroup = this.getResourceGroup();
        result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
        Subscription $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        Region $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $adminName = this.getAdminName();
        result = result * 59 + ($adminName == null ? 43 : $adminName.hashCode());
        String $adminPassword = this.getAdminPassword();
        result = result * 59 + ($adminPassword == null ? 43 : $adminPassword.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $fullyQualifiedDomainName = this.getFullyQualifiedDomainName();
        result = result * 59 + ($fullyQualifiedDomainName == null ? 43 : $fullyQualifiedDomainName.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseServerConfig(name=" + this.getName() + ", resourceGroup=" + this.getResourceGroup() + ", subscription=" + this.getSubscription() + ", region=" + this.getRegion() + ", adminName=" + this.getAdminName() + ", adminPassword=" + this.getAdminPassword() + ", version=" + this.getVersion() + ", fullyQualifiedDomainName=" + this.getFullyQualifiedDomainName() + ", azureServiceAccessAllowed=" + this.isAzureServiceAccessAllowed() + ", localMachineAccessAllowed=" + this.isLocalMachineAccessAllowed() + ")";
    }
}

