/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.database.entity;

import com.microsoft.azure.toolkit.lib.common.model.AzResourceBase;
import com.microsoft.azure.toolkit.lib.common.utils.NetUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public interface IFirewallRule
extends AzResourceBase {
    public static final int MAX_FIREWALL_NAME_LENGTH = 128;
    public static final String AZURE_SERVICES_ACCESS_FIREWALL_RULE_NAME = "AllowAllWindowsAzureIps";
    public static final String IP_ALLOW_ACCESS_TO_AZURE_SERVICES = "0.0.0.0";

    @Nullable
    public String getStartIpAddress();

    @Nullable
    public String getEndIpAddress();

    @Nonnull
    public static String getLocalMachineAccessRuleName() {
        String prefix = "ClientIPAddress_";
        String suffix = "_" + NetUtils.getMac();
        int maxHostnameLength = 128 - "ClientIPAddress_".length() - suffix.length();
        String hostname = NetUtils.getHostName().replaceAll("[^a-zA-Z0-9_-]", "");
        if (StringUtils.length((CharSequence)hostname) > maxHostnameLength) {
            hostname = StringUtils.substring((String)hostname, (int)0, (int)maxHostnameLength);
        }
        return "ClientIPAddress_" + hostname + suffix;
    }
}

