/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.database.utils;

import com.microsoft.azure.toolkit.lib.database.JdbcUrl;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DatabaseTemplateUtils {
    private static final String DEFAULT_MYSQL_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String DEFAULT_SQLSERVER_DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DEFAULT_PASSWORD = "${your_password}";
    private static final String DEFAULT_USERNAME = "${your_username}";
    private static final String PROPERTY_PATTERN_SPRING = "spring.datasource.driver-class-name=%s" + System.lineSeparator() + "spring.datasource.url=%s" + System.lineSeparator() + "spring.datasource.username=%s" + System.lineSeparator() + "spring.datasource.password=%s";
    private static final String PROPERTY_PATTERN_JDBC = "String url =\"%s\";" + System.lineSeparator() + "Connection myDbConnection = DriverManager.getConnection(url, \"%s\", \"%s\");";

    public static String toSpringTemplate(@Nonnull JdbcUrl jdbcUrl, String driverClassName) {
        String driverClass = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{driverClassName, DEFAULT_MYSQL_DRIVER_CLASS_NAME});
        String username = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{jdbcUrl.getUsername(), DEFAULT_USERNAME});
        String password = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{jdbcUrl.getPassword(), DEFAULT_PASSWORD});
        String url = jdbcUrl.toString();
        return String.format(PROPERTY_PATTERN_SPRING, driverClass, url, username, password);
    }

    public static String toJdbcTemplate(@Nonnull JdbcUrl jdbcUrl) {
        String username = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{jdbcUrl.getUsername(), DEFAULT_USERNAME});
        String password = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{jdbcUrl.getPassword(), DEFAULT_PASSWORD});
        String url = jdbcUrl.toString();
        return String.format(PROPERTY_PATTERN_JDBC, url, username, password);
    }

    DatabaseTemplateUtils() {
    }

    public static DatabaseTemplateUtilsBuilder builder() {
        return new DatabaseTemplateUtilsBuilder();
    }

    public static class DatabaseTemplateUtilsBuilder {
        DatabaseTemplateUtilsBuilder() {
        }

        public DatabaseTemplateUtils build() {
            return new DatabaseTemplateUtils();
        }

        public String toString() {
            return "DatabaseTemplateUtils.DatabaseTemplateUtilsBuilder()";
        }
    }
}

